<?php
$role = getRole();
$menus = [
    'admin' => [
        'Dashboard' => BASE_URL . '/panels/admin/dashboard.php',
        'Master Data Management' => [
            'Liquor & Products' => BASE_URL . '/panels/admin/master_data.php',
            'Brands'            => BASE_URL . '/panels/admin/brands.php',
            'Sizes'             => BASE_URL . '/panels/admin/sizes.php',
            'Prices & Tax'      => BASE_URL . '/panels/admin/prices_tax.php',
            'Categories'        => BASE_URL . '/panels/admin/categories.php',
        ],
        'Counter Management' => [
            'Add/Edit Counters' => BASE_URL . '/panels/admin/counters.php',
            'Assign Users'      => BASE_URL . '/panels/admin/counters_assign.php',
            'Counter Activation'=> BASE_URL . '/panels/admin/counter_activation.php',
        ],
        'Supplier Management'   => BASE_URL . '/panels/admin/suppliers.php',
        'User & Role Management'=> BASE_URL . '/panels/admin/users.php',
        'Stock Management'      => [
            'Stock Levels'  => BASE_URL . '/panels/admin/stock_levels.php',
            'Opening Stock' => BASE_URL . '/panels/admin/opening_stock.php',
            'Adjustments'   => BASE_URL . '/panels/admin/stock_adjustments.php',
            'History'       => BASE_URL . '/panels/admin/stock_history.php',
        ],
        'Purchase Management'   => [
            'New Purchase'   => BASE_URL . '/panels/admin/new_purchase.php',
            'Purchase List'  => BASE_URL . '/panels/admin/purchase_list.php',
            'Payments'       => BASE_URL . '/panels/admin/purchase_payments.php',
        ],
        'Sales Monitoring'      => [
            'Sales Overview' => BASE_URL . '/panels/admin/sales_overview.php',
            'Counter Sales'  => BASE_URL . '/panels/admin/counter_sales.php',
            'Invoice Logs'   => BASE_URL . '/panels/admin/invoice_logs.php',
        ],
        'Stock Requests'        => [
            'Pending'            => BASE_URL . '/panels/admin/stock_requests_pending.php',
            'Approved'           => BASE_URL . '/panels/admin/stock_requests_approved.php',
            'Dispatch Tracking'  => BASE_URL . '/panels/admin/dispatch_tracking.php',
        ],
        'Reports & Analytics'   => [
            'Daily'      => BASE_URL . '/panels/admin/daily_reports.php',
            'Sales'      => BASE_URL . '/panels/admin/sales_reports.php',
            'Stock'      => BASE_URL . '/panels/admin/stock_reports.php',
            'Purchase'   => BASE_URL . '/panels/admin/purchase_reports.php',
            'FLR'        => BASE_URL . '/panels/admin/flr_reports.php',
            'Scheduled'  => BASE_URL . '/panels/admin/scheduled_reports.php',
        ],
        'System Settings'       => [
            'Company Info'   => BASE_URL . '/panels/admin/company_info.php',
            'Audit Logs'     => BASE_URL . '/panels/admin/audit_logs.php',
            'Backup/Restore' => BASE_URL . '/panels/admin/backup_restore.php',
        ],
        'Table Management'      => [
            'Floors'           => BASE_URL . '/panels/admin/floors.php',
            'Tables'           => BASE_URL . '/panels/admin/tables.php',
        ],
        'Logout'                => BASE_URL . '/logout.php',
    ],
    'warehouse' => [
        'Dashboard' => BASE_URL . '/panels/warehouse/dashboard.php',
        'Stock Management' => [
            'View Stock' => BASE_URL . '/panels/warehouse/view_stock.php',
            'Receive Stock' => BASE_URL . '/panels/warehouse/receive_stock.php',
            'Stock Adjustment' => BASE_URL . '/panels/warehouse/stock_adjustment.php',
        ],
        'Stock Requests' => [
            'View Requests' => BASE_URL . '/panels/warehouse/stock_requests.php',
            'Dispatch Stock' => BASE_URL . '/panels/warehouse/dispatch_stock.php',
        ],
        'Purchase Management' => [
            'View Purchases' => BASE_URL . '/panels/warehouse/purchase_list.php',
            'Add New Purchase' => BASE_URL . '/panels/warehouse/purchase_form.php',
        ],
        'Reports & Logs' => [
            'Stock Report' => BASE_URL . '/panels/warehouse/stock_report.php',
            'Purchase Report' => BASE_URL . '/panels/warehouse/purchase_report.php',
            'Movement Log' => BASE_URL . '/panels/warehouse/movement_log.php',
        ],
        'Settings' => [
            'Warehouse Details' => BASE_URL . '/panels/warehouse/warehouse_details.php',
            'Notification Settings' => BASE_URL . '/panels/warehouse/notification_settings.php',
        ],
        'Logout' => BASE_URL . '/logout.php',
    ],
    'manager' => [
        'Dashboard' => BASE_URL . '/panels/manager/dashboard.php',
        'Counter Stock Oversight' => [
            'View Counter Stock'        => BASE_URL . '/panels/manager/counter_stock.php',
            'Stock Adjustment Requests' => BASE_URL . '/panels/manager/stock_adjustment_requests.php',
        ],
        'Stock Request Management' => [
            'View Requests'               => BASE_URL . '/panels/manager/stock_requests.php',
            'Approve/Reject Requests'     => BASE_URL . '/panels/manager/stock_requests_approval.php',
            'Dispatch Monitoring'         => BASE_URL . '/panels/manager/dispatch_monitoring.php',
        ],
        'Day Opening & Closing Oversight' => [
            'Opening Stock Summary'      => BASE_URL . '/panels/manager/opening_stock_summary.php',
            'Closing Stock Validation'   => BASE_URL . '/panels/manager/closing_stock_validation.php',
        ],
        'Sales Oversight' => [
            'Counter-wise Sales Summary' => BASE_URL . '/panels/manager/sales_summary.php',
            'Invoice Tracker'            => BASE_URL . '/panels/manager/invoice_tracker.php',
        ],
        'Performance Reports' => [
            'Sales Reports'          => BASE_URL . '/panels/manager/sales_reports.php',
            'Stock Reports'          => BASE_URL . '/panels/manager/stock_reports.php',
            'Request & Dispatch Logs'=> BASE_URL . '/panels/manager/request_dispatch_logs.php',
        ],
        'Counter & User Monitoring' => [
            'Activities Log'          => BASE_URL . '/panels/manager/activities_log.php',
            'Submit Feedback'         => BASE_URL . '/panels/manager/feedback.php',
        ],
        'Profile & Security' => [
            'Profile'                 => BASE_URL . '/panels/manager/profile.php',
            'Change Password'         => BASE_URL . '/panels/manager/change_password.php',
        ],
        'Logout'                  => BASE_URL . '/logout.php',
    ],
    'sales' => [
        'Dashboard'             => BASE_URL . '/panels/sales/dashboard.php',
        'POS System'            => [
            'Dine-In'            => BASE_URL . '/panels/sales/pos.php?type=dinein',
            'Takeaway'           => BASE_URL . '/panels/sales/pos.php?type=takeaway',
            'Delivery'           => BASE_URL . '/panels/sales/pos.php?type=delivery',
        ],
        'Day Opening'           => BASE_URL . '/panels/sales/day_opening.php',
        'Day Closing'           => BASE_URL . '/panels/sales/day_closing.php',
        'Table Management'      => BASE_URL . '/panels/sales/table_management.php',
        'Stock Management'      => [
            'Current Stock'     => BASE_URL . '/panels/sales/current_stock.php',
            'Request Stock'     => BASE_URL . '/panels/sales/request_stock.php',
            'History'           => BASE_URL . '/panels/sales/stock_request_history.php',
        ],
        'Sales History'         => [
            'All Orders'        => BASE_URL . '/panels/sales/sales_history.php',
            'Invoices'          => BASE_URL . '/panels/sales/invoices.php',
            'Cancel/Refund'     => BASE_URL . '/panels/sales/cancellations.php',
        ],
        'Reports'               => [
            'Daily Sales'       => BASE_URL . '/panels/sales/daily_sales_report.php',
            'Product-wise'      => BASE_URL . '/panels/sales/product_sales_report.php',
            'Payment Modes'     => BASE_URL . '/panels/sales/payment_mode_report.php',
            'Table-wise'        => BASE_URL . '/panels/sales/table_sales_report.php',
            'Low Stock'         => BASE_URL . '/panels/sales/low_stock_report.php',
        ],
        'Profile & Settings'    => [
            'Edit Profile'      => BASE_URL . '/panels/sales/profile.php',
            'Change Password'   => BASE_URL . '/panels/sales/change_password.php',
        ],
        'Logout'                => BASE_URL . '/logout.php',
    ],
];
$panelMenus = $menus[$role] ?? [];

// Mapping labels to FontAwesome icons
$menuIcons = [
    'Dashboard'=>'fa-tachometer-alt',
    'Master Data Management'=>'fa-database',
    'Liquor & Products'=>'fa-wine-bottle',
    'Brands'=>'fa-tags',
    'Sizes'=>'fa-ruler',
    'Prices & Tax'=>'fa-tags',
    'Categories'=>'fa-list',
    'Counter Management'=>'fa-cogs',
    'Add/Edit Counters'=>'fa-plus-square',
    'Assign Users'=>'fa-user-tag',
    'Counter Activation'=>'fa-power-off',
    'Supplier Management'=>'fa-truck-loading',
    'User & Role Management'=>'fa-users-cog',
    'Stock Management'=>'fa-boxes',
    'Stock Levels'=>'fa-layer-group',
    'Opening Stock'=>'fa-box-open',
    'Adjustments'=>'fa-balance-scale',
    'History'=>'fa-history',
    'Purchase Management'=>'fa-shopping-cart',
    'New Purchase'=>'fa-cart-plus',
    'Purchase List'=>'fa-list-alt',
    'Payments'=>'fa-credit-card',
    'Sales Monitoring'=>'fa-chart-line',
    'Sales Overview'=>'fa-chart-bar',
    'Counter Sales'=>'fa-cash-register',
    'Invoice Logs'=>'fa-file-invoice',
    'Stock Requests'=>'fa-clipboard-list',
    'Pending'=>'fa-hourglass-half',
    'Approved'=>'fa-check-circle',
    'Dispatch Tracking'=>'fa-shipping-fast',
    'Reports & Analytics'=>'fa-chart-pie',
    'Daily'=>'fa-calendar-day',
    'Sales'=>'fa-dollar-sign',
    'Stock'=>'fa-warehouse',
    'Purchase'=>'fa-shopping-basket',
    'FLR'=>'fa-file-alt',
    'Scheduled'=>'fa-calendar-alt',
    'System Settings'=>'fa-sliders-h',
    'Company Info'=>'fa-building',
    'Audit Logs'=>'fa-clipboard-check',
    'Backup/Restore'=>'fa-database',
    'Logout'=>'fa-sign-out-alt',
    'View Stock'=>'fa-eye',
    'Receive Stock'=>'fa-download',
    'Stock Adjustment'=>'fa-edit',
    'View Requests'=>'fa-eye',
    'Dispatch Stock'=>'fa-truck',
    'View Purchases'=>'fa-eye',
    'Add New Purchase'=>'fa-plus',
    'Stock Report'=>'fa-file-alt',
    'Purchase Report'=>'fa-file-alt',
    'Movement Log'=>'fa-file-alt',
    'Warehouse Details'=>'fa-building',
    'Notification Settings'=>'fa-bell',
    'Counter Stock Oversight'=>'fa-eye',
    'Stock Adjustment Requests'=>'fa-edit',
    'Stock Request Management'=>'fa-clipboard-list',
    'View Requests'=>'fa-eye',
    'Approve/Reject Requests'=>'fa-check-circle',
    'Dispatch Monitoring'=>'fa-shipping-fast',
    'Day Opening & Closing Oversight'=>'fa-calendar-alt',
    'Opening Stock Summary'=>'fa-box-open',
    'Closing Stock Validation'=>'fa-check-circle',
    'Sales Oversight'=>'fa-chart-line',
    'Counter-wise Sales Summary'=>'fa-chart-bar',
    'Invoice Tracker'=>'fa-file-invoice',
    'Performance Reports'=>'fa-chart-pie',
    'Sales Reports'=>'fa-dollar-sign',
    'Stock Reports'=>'fa-warehouse',
    'Request & Dispatch Logs'=>'fa-file-alt',
    'Counter & User Monitoring'=>'fa-users-cog',
    'Activities Log'=>'fa-clipboard-check',
    'Submit Feedback'=>'fa-comment',
    'Profile & Security'=>'fa-sliders-h',
    'Profile'=>'fa-user',
    'Change Password'=>'fa-lock',
    'Table Management'      => 'fa-table',
    'POS System'            => 'fa-desktop',
    'Dine-In'               => 'fa-utensils',
    'Takeaway'              => 'fa-shopping-bag',
    'Delivery'              => 'fa-truck',
    'Current Stock'         => 'fa-boxes',
    'Request Stock'         => 'fa-clipboard-list',
    'All Orders'            => 'fa-list-alt',
    'Invoices'              => 'fa-file-invoice',
    'Cancel/Refund'         => 'fa-ban',
    'Daily Sales'           => 'fa-calendar-day',
    'Product-wise'          => 'fa-tags',
    'Payment Modes'         => 'fa-credit-card',
    'Table-wise'            => 'fa-table',
    'Low Stock'             => 'fa-exclamation-triangle',
    'Edit Profile'          => 'fa-user-edit',
    'Day Opening'           => 'fa-calendar-day',
    'Day Closing'           => 'fa-calendar-alt',
    'Menu (Product List)'   => 'fa-list-alt',
    'Table Services'        => 'fa-utensils',
    'Takeaway Orders'       => 'fa-shopping-bag',
    'Delivery Orders'       => 'fa-truck',
    'Order History'         => 'fa-file-alt',
    'Daily Summary'         => 'fa-calendar-day',
    'Printer Settings'      => 'fa-print',
];

// Colors for sidebar icons
$menuIconColors = [
    'Dashboard'=>'primary',
    'Master Data Management'=>'secondary',
    'Liquor & Products'=>'danger',
    'Brands'=>'info',
    'Sizes'=>'warning',
    'Prices & Tax'=>'success',
    'Categories'=>'dark',
    'Counter Management'=>'primary',
    'Add/Edit Counters'=>'secondary',
    'Assign Users'=>'danger',
    'Counter Activation'=>'info',
    'Supplier Management'=>'warning',
    'User & Role Management'=>'success',
    'Stock Management'=>'dark',
    'Stock Levels'=>'primary',
    'Opening Stock'=>'secondary',
    'Adjustments'=>'danger',
    'History'=>'info',
    'Purchase Management'=>'warning',
    'New Purchase'=>'success',
    'Purchase List'=>'dark',
    'Payments'=>'primary',
    'Sales Monitoring'=>'secondary',
    'Sales Overview'=>'danger',
    'Counter Sales'=>'info',
    'Invoice Logs'=>'warning',
    'Stock Requests'=>'success',
    'Pending'=>'dark',
    'Approved'=>'primary',
    'Dispatch Tracking'=>'secondary',
    'Reports & Analytics'=>'danger',
    'Daily'=>'info',
    'Sales'=>'warning',
    'Stock'=>'success',
    'Purchase'=>'dark',
    'FLR'=>'primary',
    'Scheduled'=>'secondary',
    'System Settings'=>'danger',
    'Company Info'=>'info',
    'Audit Logs'=>'warning',
    'Backup/Restore'=>'success',
    'Logout'=>'dark',
    'View Stock'=>'primary',
    'Receive Stock'=>'secondary',
    'Stock Adjustment'=>'danger',
    'View Requests'=>'info',
    'Dispatch Stock'=>'warning',
    'View Purchases'=>'success',
    'Add New Purchase'=>'dark',
    'Stock Report'=>'primary',
    'Purchase Report'=>'secondary',
    'Movement Log'=>'danger',
    'Warehouse Details'=>'info',
    'Notification Settings'=>'warning',
    'Counter Stock Oversight'=>'primary',
    'Stock Adjustment Requests'=>'secondary',
    'Stock Request Management'=>'danger',
    'View Requests'=>'info',
    'Approve/Reject Requests'=>'warning',
    'Dispatch Monitoring'=>'success',
    'Day Opening & Closing Oversight'=>'dark',
    'Opening Stock Summary'=>'primary',
    'Closing Stock Validation'=>'secondary',
    'Sales Oversight'=>'danger',
    'Counter-wise Sales Summary'=>'info',
    'Invoice Tracker'=>'warning',
    'Performance Reports'=>'success',
    'Sales Reports'=>'dark',
    'Stock Reports'=>'primary',
    'Request & Dispatch Logs'=>'secondary',
    'Counter & User Monitoring'=>'danger',
    'Activities Log'=>'info',
    'Submit Feedback'=>'warning',
    'Profile & Security'=>'success',
    'Profile'=>'dark',
    'Change Password'=>'primary',
    'Table Management'      => 'primary',
    'POS System'            => 'secondary',
    'Dine-In'               => 'danger',
    'Takeaway'              => 'info',
    'Delivery'              => 'warning',
    'Current Stock'         => 'success',
    'Request Stock'         => 'dark',
    'All Orders'            => 'primary',
    'Invoices'              => 'secondary',
    'Cancel/Refund'         => 'danger',
    'Daily Sales'           => 'info',
    'Product-wise'          => 'warning',
    'Payment Modes'         => 'success',
    'Table-wise'            => 'dark',
    'Low Stock'             => 'primary',
    'Edit Profile'          => 'secondary',
    'Day Opening'           => 'primary',
    'Day Closing'           => 'secondary',
    'Menu (Product List)'   => 'primary',
    'Table Services'        => 'secondary',
    'Takeaway Orders'       => 'danger',
    'Delivery Orders'       => 'info',
    'Order History'         => 'warning',
    'Daily Summary'         => 'success',
    'Printer Settings'      => 'dark',
];

?>
<nav class="col-md-3 col-lg-2 d-md-block sidebar collapse show">
  <div class="position-sticky pt-3">
    <ul class="nav flex-column">
      <?php foreach ($panelMenus as $label => $item): ?>
        <?php if (is_string($item)): ?>
          <li class="nav-item">
            <a class="nav-link" href="<?= $item ?>">
              <i class="fas <?= $menuIcons[$label] ?? 'fa-circle' ?> me-2 text-<?= $menuIconColors[$label] ?? 'dark' ?>" style="font-size:1.25rem;"></i><?= $label ?>
            </a>
          </li>
        <?php else: ?>
          <?php $id = preg_replace('/[^a-zA-Z0-9]/', '', $label) . 'Menu'; ?>
          <li class="nav-item mt-2">
            <a class="nav-link collapsed d-flex justify-content-between align-items-center" data-bs-toggle="collapse" href="#<?= $id ?>" role="button" aria-expanded="false">
              <span><i class="fas <?= $menuIcons[$label] ?? 'fa-circle' ?> me-2 text-<?= $menuIconColors[$label] ?? 'dark' ?>" style="font-size:1.25rem;"></i><?= $label ?></span>
              <i class="fas fa-chevron-down"></i>
            </a>
            <ul class="nav flex-column collapse" id="<?= $id ?>">
              <?php foreach ($item as $subLabel => $subLink): ?>
                <li class="nav-item ms-3">
                  <a class="nav-link" href="<?= $subLink ?>">
                    <i class="fas <?= $menuIcons[$subLabel] ?? 'fa-dot-circle' ?> me-2 text-<?= $menuIconColors[$subLabel] ?? 'dark' ?>" style="font-size:1.25rem;"></i><?= $subLabel ?>
                  </a>
                </li>
              <?php endforeach; ?>
            </ul>
          </li>
        <?php endif; ?>
      <?php endforeach; ?>
    </ul>
  </div>
</nav>
