<?php
// Thermal Receipt Template
// Variables expected: $companyInfo, $sale, $items (array), $printerSettings, $qrUrl (if QR enabled)
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>Receipt #<?= $sale['id'] ?></title>
  <style>
    .receipt-thermal { width:80mm; margin:auto; font-family:monospace; font-size:12px; }
    .receipt-thermal .header, .receipt-thermal .footer { text-align:center; }
    .receipt-thermal .items { margin:10px 0; }
    .receipt-thermal .item { display:flex; justify-content:space-between; }
    .receipt-thermal .total { display:flex; justify-content:space-between; font-weight:bold; margin-top:10px; }
    img.qr { display:block; margin:10px auto; width:80px; height:80px; }
  </style>
</head>
<body>
<div class="receipt-thermal">
  <div class="header">
    <?php if (!empty($printerSettings['header_text'])): ?>
      <?= nl2br(htmlspecialchars($printerSettings['header_text'])) ?>
    <?php else: ?>
      <strong><?= htmlspecialchars($companyInfo['company_name'] ?? '') ?></strong><br>
      <?= nl2br(htmlspecialchars($companyInfo['address'] ?? '')) ?>
    <?php endif; ?>
  </div>
  <div class="items">
    <?php foreach ($items as $it): ?>
      <div class="item">
        <span><?= htmlspecialchars(substr($it['name'],0,20)) ?> x<?= intval($it['quantity']) ?></span>
        <span>₹<?= number_format($it['total'],2) ?></span>
      </div>
    <?php endforeach; ?>
  </div>
  <div class="total">
    <span>Total</span>
    <span>₹<?= number_format($sale['total_amount'],2) ?></span>
  </div>
  <?php if (!empty($qrUrl) && !empty($printerSettings['qr_code_enable'])): ?>
    <img src="<?= $qrUrl ?>" alt="QR Code" class="qr">
    <p style="text-align:center;">Scan to Pay</p>
  <?php endif; ?>
  <div class="footer">
    <?= nl2br(htmlspecialchars($printerSettings['footer_text'] ?? 'Thank you!')) ?>
  </div>
</div>
</body>
</html>
