<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'admin') redirect(BASE_URL . '/login.php');

$error = '';
$success = '';

// Handle Backup download
if (isset($_GET['action']) && $_GET['action'] === 'backup') {
    $filename = 'backup_' . date('Ymd_His') . '.sql';
    header('Content-Type: application/sql');
    header('Content-Disposition: attachment; filename="' . $filename . '"');
    $command = sprintf(
        'mysqldump --host=%s --user=%s --password=%s %s',
        escapeshellarg(DB_HOST),
        escapeshellarg(DB_USER),
        escapeshellarg(DB_PASS),
        escapeshellarg(DB_NAME)
    );
    passthru($command);
    exit;
}

// Handle Restore upload
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_FILES['backup_file']) && $_FILES['backup_file']['error'] === UPLOAD_ERR_OK) {
        $tmp = $_FILES['backup_file']['tmp_name'];
        $ext = pathinfo($_FILES['backup_file']['name'], PATHINFO_EXTENSION);
        if (strtolower($ext) === 'sql') {
            $sql = file_get_contents($tmp);
            if (!mysqli_multi_query($conn, $sql)) {
                $error = 'Restore failed: ' . mysqli_error($conn);
            } else {
                do { } while (mysqli_more_results($conn) && mysqli_next_result($conn));
                $success = 'Database restored successfully.';
            }
        } else {
            $error = 'Please upload a valid .sql file.';
        }
    } else {
        $error = 'Error uploading file.';
    }
}

ob_start();
?>
<h1>Backup & Restore</h1>
<?php if ($error): ?><div class="alert alert-danger"><?= htmlspecialchars($error) ?></div><?php endif; ?>
<?php if ($success): ?><div class="alert alert-success"><?= htmlspecialchars($success) ?></div><?php endif; ?>
<div class="row">
  <div class="col-md-6 mb-4">
    <h3>Backup Database</h3>
    <p>Download a SQL dump of the current database.</p>
    <a href="?action=backup" class="btn btn-primary">Download Backup</a>
  </div>
  <div class="col-md-6">
    <h3>Restore Database</h3>
    <p>Upload a .sql file to restore the database.</p>
    <form method="post" enctype="multipart/form-data">
      <div class="mb-3">
        <input type="file" name="backup_file" accept=".sql" required>
      </div>
      <button type="submit" class="btn btn-warning">Restore</button>
    </form>
  </div>
</div>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
