<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'admin') {
    redirect(BASE_URL . '/login.php');
}
// Handle delete
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    mysqli_query($conn, "DELETE FROM categories WHERE id = $id");
    redirect(BASE_URL . '/panels/admin/categories.php');
}
// Fetch categories
$result = mysqli_query($conn, "SELECT * FROM categories ORDER BY name");
$categories = mysqli_fetch_all($result, MYSQLI_ASSOC);
ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h1>Categories</h1>
  <a href="<?= BASE_URL ?>/panels/admin/category_form.php" class="btn btn-primary">Add Category</a>
</div>
<table class="table table-bordered table-striped">
  <thead>
    <tr><th>ID</th><th>Name</th><th>Actions</th></tr>
  </thead>
  <tbody>
    <?php foreach ($categories as $c): ?>
    <tr>
      <td><?= $c['id'] ?></td>
      <td><?= htmlspecialchars($c['name']) ?></td>
      <td>
        <a href="<?= BASE_URL ?>/panels/admin/category_form.php?id=<?= $c['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
        <a href="<?= BASE_URL ?>/panels/admin/categories.php?delete=<?= $c['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this category?')">Delete</a>
      </td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
