<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'admin') redirect(BASE_URL . '/login.php');

// Ensure logo & favicon columns exist
$col = mysqli_query($conn, "SHOW COLUMNS FROM `company_info` LIKE 'logo'") or die('Error checking logo column: '.mysqli_error($conn));
if (mysqli_num_rows($col) === 0) {
    mysqli_query($conn, "ALTER TABLE `company_info` ADD COLUMN `logo` VARCHAR(255) DEFAULT NULL") or die('Error adding logo column: '.mysqli_error($conn));
}
$col = mysqli_query($conn, "SHOW COLUMNS FROM `company_info` LIKE 'favicon'") or die('Error checking favicon column: '.mysqli_error($conn));
if (mysqli_num_rows($col) === 0) {
    mysqli_query($conn, "ALTER TABLE `company_info` ADD COLUMN `favicon` VARCHAR(255) DEFAULT NULL") or die('Error adding favicon column: '.mysqli_error($conn));
}

$error = '';
$success = '';
$id = 0;
$company_name = '';
$address = '';
$phone = '';
$email = '';
$vat_number = '';
$pin_code = '';
$logo_path = '';
$favicon_path = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = intval($_POST['id'] ?? 0);
    $company_name = trim($_POST['company_name'] ?? '');
    $address = trim($_POST['address'] ?? '');
    $phone = trim($_POST['phone'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $vat_number = trim($_POST['vat_number'] ?? '');
    $pin_code = trim($_POST['pin_code'] ?? '');
    if (!$company_name) {
        $error = 'Company Name is required.';
    } else {
        // handle uploads
        if (!file_exists(__DIR__ . '/../../assets/images')) mkdir(__DIR__ . '/../../assets/images', 0755, true);
        // Logo
        if (isset($_FILES['logo']) && $_FILES['logo']['error'] === UPLOAD_ERR_OK) {
            $ext = pathinfo($_FILES['logo']['name'], PATHINFO_EXTENSION);
            $fname = 'logo_'.time().'.'.$ext;
            move_uploaded_file($_FILES['logo']['tmp_name'], __DIR__.'/../../assets/images/'.$fname);
            $logo_path = '/assets/images/'.$fname;
        } else {
            $logo_path = $_POST['existing_logo'] ?? '';
        }
        // Favicon
        if (isset($_FILES['favicon']) && $_FILES['favicon']['error'] === UPLOAD_ERR_OK) {
            $ext2 = pathinfo($_FILES['favicon']['name'], PATHINFO_EXTENSION);
            $fname2 = 'favicon_'.time().'.'.$ext2;
            move_uploaded_file($_FILES['favicon']['tmp_name'], __DIR__.'/../../assets/images/'.$fname2);
            $favicon_path = '/assets/images/'.$fname2;
        } else {
            $favicon_path = $_POST['existing_favicon'] ?? '';
        }
        if ($id) {
            $stmt = mysqli_prepare($conn, "UPDATE company_info SET company_name=?, address=?, phone=?, email=?, vat_number=?, pin_code=?, logo=?, favicon=? WHERE id=?");
            mysqli_stmt_bind_param($stmt, 'ssssssssi', $company_name, $address, $phone, $email, $vat_number, $pin_code, $logo_path, $favicon_path, $id);
        } else {
            $stmt = mysqli_prepare($conn, "INSERT INTO company_info (company_name,address,phone,email,vat_number,pin_code,logo,favicon) VALUES (?,?,?,?,?,?,?,?)");
            mysqli_stmt_bind_param($stmt, 'ssssssss', $company_name, $address, $phone, $email, $vat_number, $pin_code, $logo_path, $favicon_path);
        }
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);
        $success = $id ? 'Company info updated successfully.' : 'Company info created successfully.';
        redirect(BASE_URL . '/panels/admin/company_info.php?success=1');
    }
}

// On GET, load existing record if any
$res = mysqli_query($conn, "SELECT * FROM company_info LIMIT 1") or die(mysqli_error($conn));
if ($row = mysqli_fetch_assoc($res)) {
    if (!$id) $id = $row['id'];
    $company_name = $row['company_name'];
    $address = $row['address'];
    $phone = $row['phone'];
    $email = $row['email'];
    $vat_number = $row['vat_number'];
    $pin_code = $row['pin_code'];
    $logo_path = $row['logo'];
    $favicon_path = $row['favicon'];
}

if (isset($_GET['success'])) {
    $success = 'Company information saved successfully.';
}

ob_start();
?>
<h1>Company Information</h1>
<?php if ($error): ?>
  <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
<?php endif; ?>
<?php if ($success): ?>
  <div class="alert alert-success"><?= htmlspecialchars($success) ?></div>
<?php endif; ?>

<form method="post" enctype="multipart/form-data">
  <input type="hidden" name="id" value="<?= $id ?>">
  <div class="mb-3">
    <label class="form-label">Company Name</label>
    <input type="text" name="company_name" class="form-control" value="<?= htmlspecialchars($company_name) ?>" required>
  </div>
  <div class="mb-3">
    <label class="form-label">Address</label>
    <textarea name="address" class="form-control"><?= htmlspecialchars($address) ?></textarea>
  </div>
  <div class="mb-3">
    <label class="form-label">Phone</label>
    <input type="text" name="phone" class="form-control" value="<?= htmlspecialchars($phone) ?>">
  </div>
  <div class="mb-3">
    <label class="form-label">Email</label>
    <input type="email" name="email" class="form-control" value="<?= htmlspecialchars($email) ?>">
  </div>
  <div class="mb-3">
    <label class="form-label">VAT Number</label>
    <input type="text" name="vat_number" class="form-control" value="<?= htmlspecialchars($vat_number) ?>">
  </div>
  <div class="mb-3">
    <label class="form-label">PIN Code</label>
    <input type="text" name="pin_code" class="form-control" value="<?= htmlspecialchars($pin_code) ?>">
  </div>
  <input type="hidden" name="existing_logo" value="<?= htmlspecialchars($logo_path) ?>">
  <div class="mb-3">
    <label class="form-label">Logo</label>
    <?php if ($logo_path): ?>
      <div><img src="<?= BASE_URL.$logo_path ?>" height="80"></div>
    <?php endif; ?>
    <input type="file" name="logo" class="form-control">
  </div>
  <input type="hidden" name="existing_favicon" value="<?= htmlspecialchars($favicon_path) ?>">
  <div class="mb-3">
    <label class="form-label">Favicon</label>
    <?php if ($favicon_path): ?>
      <div><img src="<?= BASE_URL.$favicon_path ?>" height="32"></div>
    <?php endif; ?>
    <input type="file" name="favicon" class="form-control">
  </div>
  <button type="submit" class="btn btn-success">Save</button>
</form>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
