<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'admin') {
    redirect(BASE_URL . '/login.php');
}
// Handle delete
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    mysqli_query($conn, "DELETE FROM counters WHERE id = $id");
    redirect(BASE_URL . '/panels/admin/counters.php');
}
// Fetch counters
$result = mysqli_query($conn, "SELECT * FROM counters ORDER BY name");
$counters = mysqli_fetch_all($result, MYSQLI_ASSOC);
ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h1>Counters</h1>
  <a href="<?= BASE_URL ?>/panels/admin/counter_form.php" class="btn btn-primary">Add Counter</a>
</div>
<table class="table table-bordered table-striped">
  <thead>
    <tr><th>ID</th><th>Name</th><th>Actions</th></tr>
  </thead>
  <tbody>
    <?php foreach ($counters as $c): ?>
    <tr>
      <td><?= $c['id'] ?></td>
      <td><?= htmlspecialchars($c['name']) ?></td>
      <td>
        <a href="<?= BASE_URL ?>/panels/admin/counter_form.php?id=<?= $c['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
        <a href="<?= BASE_URL ?>/panels/admin/counters.php?delete=<?= $c['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this counter?')">Delete</a>
      </td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
