<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'admin') redirect(BASE_URL . '/login.php');
// Handle assignment update
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $userId = intval($_POST['user_id'] ?? 0);
    $cidRaw = $_POST['assigned_counter_id'] ?? '';
    if ($userId) {
        if ($cidRaw === '') {
            $stmt = mysqli_prepare($conn, "UPDATE users SET assigned_counter_id = NULL WHERE id = ?");
            mysqli_stmt_bind_param($stmt, 'i', $userId);
        } else {
            $cid = intval($cidRaw);
            $stmt = mysqli_prepare($conn, "UPDATE users SET assigned_counter_id = ? WHERE id = ?");
            mysqli_stmt_bind_param($stmt, 'ii', $cid, $userId);
        }
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);
    }
    redirect(BASE_URL . '/panels/admin/counters_assign.php');
}
// Fetch counters and users
$counters = mysqli_fetch_all(mysqli_query($conn, "SELECT id, name FROM counters ORDER BY name"), MYSQLI_ASSOC);
$users = mysqli_fetch_all(mysqli_query($conn, "SELECT id, username, role, assigned_counter_id FROM users ORDER BY username"), MYSQLI_ASSOC);
ob_start();
?>
<h1>Assign Users to Counters</h1>
<table class="table table-bordered table-striped">
  <thead>
    <tr><th>User</th><th>Role</th><th>Counter Assignment</th><th>Action</th></tr>
  </thead>
  <tbody>
    <?php foreach ($users as $u): ?>
    <tr>
      <td><?= htmlspecialchars($u['username']) ?></td>
      <td><?= htmlspecialchars($u['role']) ?></td>
      <td>
        <form method="post" class="d-flex align-items-center">
          <input type="hidden" name="user_id" value="<?= $u['id'] ?>">
          <select name="assigned_counter_id" class="form-select me-2" style="width:auto;">
            <option value="" <?= ($u['assigned_counter_id'] === null) ? 'selected' : '' ?>>-- Unassigned --</option>
            <?php foreach ($counters as $c): ?>
            <option value="<?= $c['id'] ?>" <?= ($u['assigned_counter_id'] == $c['id']) ? 'selected' : '' ?>><?= htmlspecialchars($c['name']) ?></option>
            <?php endforeach; ?>
          </select>
          <button class="btn btn-primary btn-sm">Update</button>
        </form>
      </td>
      <td></td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
