<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'admin') {
    redirect(BASE_URL . '/login.php');
}
// Fetch metrics
$res = mysqli_query($conn, "SELECT COUNT(*) AS cnt FROM sales WHERE DATE(sale_date)=CURDATE()");
$todaySales = mysqli_fetch_assoc($res)['cnt'] ?? 0;
$res = mysqli_query($conn, "SELECT COUNT(*) AS cnt FROM stock_requests WHERE status='pending'");
$pendingRequests = mysqli_fetch_assoc($res)['cnt'] ?? 0;
$res = mysqli_query($conn, "SELECT COUNT(*) AS cnt FROM purchases WHERE DATE(purchase_date)=CURDATE()");
$purchasesToday = mysqli_fetch_assoc($res)['cnt'] ?? 0;
$res = mysqli_query($conn, "SELECT COUNT(*) AS cnt FROM products");
$totalProducts = mysqli_fetch_assoc($res)['cnt'] ?? 0;
$res = mysqli_query($conn, "SELECT COUNT(*) AS cnt FROM counters");
$totalCounters = mysqli_fetch_assoc($res)['cnt'] ?? 0;
$res = mysqli_query($conn, "SELECT COUNT(*) AS cnt FROM users");
$totalUsers = mysqli_fetch_assoc($res)['cnt'] ?? 0;
$res = mysqli_query($conn, "SELECT COUNT(*) AS cnt FROM suppliers");
$totalSuppliers = mysqli_fetch_assoc($res)['cnt'] ?? 0;
ob_start();
?>
<div class="d-flex justify-content-between flex-wrap mb-4">
    <h1 class="h2">Dashboard</h1>
    <small class="text-muted">Welcome, <?= htmlspecialchars($_SESSION['username'] ?? '') ?></small>
</div>
<div class="row g-3">
    <?php $widgets = [
        ['icon'=>'fa-shopping-bag','value'=>$todaySales,'label'=>'Sales Today','color'=>'primary'],
        ['icon'=>'fa-clock','value'=>$pendingRequests,'label'=>'Pending Requests','color'=>'warning'],
        ['icon'=>'fa-truck','value'=>$purchasesToday,'label'=>'Purchases Today','color'=>'info'],
        ['icon'=>'fa-boxes','value'=>$totalProducts,'label'=>'Total Products','color'=>'success'],
        ['icon'=>'fa-building','value'=>$totalCounters,'label'=>'Total Counters','color'=>'secondary'],
        ['icon'=>'fa-users','value'=>$totalUsers,'label'=>'Total Users','color'=>'dark'],
        ['icon'=>'fa-store','value'=>$totalSuppliers,'label'=>'Suppliers','color'=>'danger'],
    ]; ?>
    <?php foreach ($widgets as $w): ?>
    <div class="col-6 col-md-4 col-lg-3">
        <div class="card text-center">
            <div class="card-body">
                <div class="widget-icon-wrapper bg-<?= $w['color'] ?> mx-auto mb-3">
                    <i class="fas <?= $w['icon'] ?> text-white"></i>
                </div>
                <h3><?= $w['value'] ?></h3>
                <p class="mb-0"><?= $w['label'] ?></p>
            </div>
        </div>
    </div>
    <?php endforeach; ?>
</div>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
