<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'admin') redirect(BASE_URL . '/login.php');

// Ensure stock_requests table exists
$create = "CREATE TABLE IF NOT EXISTS `stock_requests` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `counter_id` INT UNSIGNED DEFAULT NULL,
  `product_id` INT UNSIGNED NOT NULL,
  `quantity` INT NOT NULL DEFAULT 0,
  `remarks` TEXT,
  `status` ENUM('pending','approved','dispatched','rejected') NOT NULL DEFAULT 'pending',
  `created_by` INT UNSIGNED DEFAULT NULL,
  `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_sr_counter` (`counter_id`),
  KEY `fk_sr_product` (`product_id`),
  KEY `fk_sr_user` (`created_by`),
  CONSTRAINT `fk_sr_counter` FOREIGN KEY (`counter_id`) REFERENCES `counters`(`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_sr_product` FOREIGN KEY (`product_id`) REFERENCES `products`(`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_sr_user` FOREIGN KEY (`created_by`) REFERENCES `users`(`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci";
mysqli_query($conn, $create) or die('Error ensuring stock_requests table: '.mysqli_error($conn));

// Ensure required columns
$cols = [
    'counter_id' => "INT UNSIGNED DEFAULT NULL",
    'product_id' => "INT UNSIGNED NOT NULL",
    'quantity'   => "INT NOT NULL DEFAULT 0",
    'remarks'    => "TEXT",
    'status'     => "ENUM('pending','approved','dispatched','rejected') NOT NULL DEFAULT 'pending'",
    'created_by' => "INT UNSIGNED DEFAULT NULL",
];
foreach ($cols as $colName => $colType) {
    $colCheck = mysqli_query($conn, "SHOW COLUMNS FROM `stock_requests` LIKE '$colName'") or die("Error checking $colName: ".mysqli_error($conn));
    if (mysqli_num_rows($colCheck) === 0) {
        mysqli_query($conn, "ALTER TABLE `stock_requests` ADD COLUMN `$colName` $colType") or die("Error adding $colName: ".mysqli_error($conn));
    }
}

// Fetch dispatched requests
$qcol = mysqli_query($conn, "SHOW COLUMNS FROM `stock_requests` LIKE 'quantity'") or die('Error checking quantity: '.mysqli_error($conn));
$hasQty = mysqli_num_rows($qcol) > 0;
$fields = "sr.id, sr.created_at, COALESCE(c.name,'') AS counter_name, COALESCE(p.name,'') AS product_name";
if ($hasQty) { $fields .= ", sr.quantity"; } else { $fields .= ", 0 AS quantity"; }
$fields .= ", sr.remarks, COALESCE(u.username,'') AS requested_by";
$sql = "SELECT $fields
    FROM stock_requests sr
    LEFT JOIN counters c ON sr.counter_id = c.id
    LEFT JOIN products p ON sr.product_id = p.id
    LEFT JOIN users u ON sr.created_by = u.id
    WHERE sr.status = 'dispatched'
    ORDER BY sr.created_at DESC";
$res = mysqli_query($conn, $sql) or die('Error fetching dispatched requests: '.mysqli_error($conn));
$rows = mysqli_fetch_all($res, MYSQLI_ASSOC);

ob_start();
?>
<h1>Dispatch Tracking</h1>
<table class="table table-bordered table-striped">
  <thead>
    <tr>
      <th>ID</th>
      <th>Date</th>
      <th>Counter</th>
      <th>Product</th>
      <th>Quantity</th>
      <th>Remarks</th>
      <th>Requested By</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($rows as $r): ?>
    <tr>
      <td><?= $r['id'] ?></td>
      <td><?= $r['created_at'] ?></td>
      <td><?= htmlspecialchars($r['counter_name']) ?></td>
      <td><?= htmlspecialchars($r['product_name']) ?></td>
      <td><?= $r['quantity'] ?></td>
      <td><?= htmlspecialchars($r['remarks']) ?></td>
      <td><?= htmlspecialchars($r['requested_by']) ?></td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
