<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'admin') redirect(BASE_URL . '/login.php');

// Handle delete
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    mysqli_query($conn, "DELETE FROM floors WHERE id = $id");
    redirect(BASE_URL . '/panels/admin/floors.php');
}

// Fetch floors
$result = mysqli_query($conn, "SELECT * FROM floors ORDER BY name");
$floors = mysqli_fetch_all($result, MYSQLI_ASSOC);
ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h1>Floors</h1>
  <a href="<?= BASE_URL ?>/panels/admin/floor_form.php" class="btn btn-primary">Add Floor</a>
</div>
<table class="table table-bordered table-striped">
  <thead>
    <tr><th>ID</th><th>Name</th><th>Description</th><th>Actions</th></tr>
  </thead>
  <tbody>
    <?php foreach ($floors as $f): ?>
    <tr>
      <td><?= $f['id'] ?></td>
      <td><?= htmlspecialchars($f['name']) ?></td>
      <td><?= htmlspecialchars($f['description']) ?></td>
      <td>
        <a href="<?= BASE_URL ?>/panels/admin/floor_form.php?id=<?= $f['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
        <a href="<?= BASE_URL ?>/panels/admin/floors.php?delete=<?= $f['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this floor?')">Delete</a>
      </td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
