<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'admin') redirect(BASE_URL . '/login.php');

// Ensure sales table exists
$createSales = "CREATE TABLE IF NOT EXISTS `sales` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `counter_id` INT UNSIGNED DEFAULT NULL,
  `sale_date` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `total_amount` DECIMAL(10,2) NOT NULL,
  `created_by` INT UNSIGNED DEFAULT NULL,
  `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_sales_counter` (`counter_id`),
  KEY `fk_sales_user` (`created_by`),
  CONSTRAINT `fk_sales_counter` FOREIGN KEY (`counter_id`) REFERENCES `counters`(`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_sales_user` FOREIGN KEY (`created_by`) REFERENCES `users`(`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci";
mysqli_query($conn, $createSales) or die('Error ensuring sales table: '.mysqli_error($conn));

// Fetch invoice logs
$sql = "SELECT s.id AS invoice_no, s.sale_date, COALESCE(c.name, '') AS counter_name, s.total_amount, COALESCE(u.username, '') AS created_by
        FROM sales s
        LEFT JOIN counters c ON s.counter_id = c.id
        LEFT JOIN users u ON s.created_by = u.id
        ORDER BY s.sale_date DESC";
$res = mysqli_query($conn, $sql) or die('Error fetching invoice logs: '.mysqli_error($conn));
$rows = mysqli_fetch_all($res, MYSQLI_ASSOC);

ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h1>Invoice Logs</h1>
</div>
<table class="table table-bordered table-striped">
  <thead>
    <tr>
      <th>Invoice #</th>
      <th>Date</th>
      <th>Counter</th>
      <th>Total Amount</th>
      <th>Created By</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($rows as $r): ?>
    <tr>
      <td><?= sprintf('INV%04d', $r['invoice_no']) ?></td>
      <td><?= $r['sale_date'] ?></td>
      <td><?= htmlspecialchars($r['counter_name']) ?></td>
      <td><?= number_format($r['total_amount'],2) ?></td>
      <td><?= htmlspecialchars($r['created_by']) ?></td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
