<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'admin') redirect(BASE_URL . '/login.php');

// Handle delete
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    mysqli_query($conn, "DELETE FROM liquor WHERE id = $id");
    redirect(BASE_URL . '/panels/admin/liquor.php');
}

// Fetch brands & categories for display
$brandsRes = mysqli_query($conn, "SELECT id, name FROM brands ORDER BY name");
$brands = mysqli_fetch_all($brandsRes, MYSQLI_ASSOC);
$catsRes = mysqli_query($conn, "SELECT id, name FROM categories ORDER BY name");
$categories = mysqli_fetch_all($catsRes, MYSQLI_ASSOC);

// Fetch liquors
$res = mysqli_query($conn, "SELECT l.id, l.name, b.name AS brand_name, c.name AS category_name FROM liquor l LEFT JOIN brands b ON l.brand_id=b.id LEFT JOIN categories c ON l.category_id=c.id ORDER BY l.name");
$liquors = mysqli_fetch_all($res, MYSQLI_ASSOC);

ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h1>Liquors</h1>
  <a href="<?= BASE_URL ?>/panels/admin/liquor_form.php" class="btn btn-primary">Add Liquor</a>
</div>
<table class="table table-bordered table-striped">
  <thead><tr><th>ID</th><th>Name</th><th>Brand</th><th>Category</th><th>Actions</th></tr></thead>
  <tbody>
    <?php foreach ($liquors as $l): ?>
    <tr>
      <td><?= $l['id'] ?></td>
      <td><?= htmlspecialchars($l['name']) ?></td>
      <td><?= htmlspecialchars($l['brand_name']) ?></td>
      <td><?= htmlspecialchars($l['category_name']) ?></td>
      <td>
        <a href="<?= BASE_URL ?>/panels/admin/liquor_form.php?id=<?= $l['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
        <a href="<?= BASE_URL ?>/panels/admin/liquor.php?delete=<?= $l['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this liquor?')">Delete</a>
      </td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
