<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'admin') {
    redirect(BASE_URL . '/login.php');
}

$id = intval($_GET['id'] ?? 0);
$name = '';
$brand_id = 0;
$category_id = 0;
// Fetch brands and categories
$brands = mysqli_fetch_all(mysqli_query($conn, "SELECT id, name FROM brands ORDER BY name"), MYSQLI_ASSOC);
$categories = mysqli_fetch_all(mysqli_query($conn, "SELECT id, name FROM categories ORDER BY name"), MYSQLI_ASSOC);
// Load existing liquor for edit
if ($id) {
    $stmt = mysqli_prepare($conn, "SELECT name, brand_id, category_id FROM liquor WHERE id = ?");
    mysqli_stmt_bind_param($stmt, 'i', $id);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_bind_result($stmt, $name, $brand_id, $category_id);
    mysqli_stmt_fetch($stmt);
    mysqli_stmt_close($stmt);
}
$error = '';
// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name']);
    $brand_id = intval($_POST['brand_id'] ?? 0);
    $category_id = intval($_POST['category_id'] ?? 0);
    if ($name) {
        if ($id) {
            $stmt = mysqli_prepare($conn, "UPDATE liquor SET name = ?, brand_id = ?, category_id = ? WHERE id = ?");
            mysqli_stmt_bind_param($stmt, 'siii', $name, $brand_id, $category_id, $id);
        } else {
            $stmt = mysqli_prepare($conn, "INSERT INTO liquor (name, brand_id, category_id) VALUES (?, ?, ?)");
            mysqli_stmt_bind_param($stmt, 'sii', $name, $brand_id, $category_id);
        }
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);
        redirect(BASE_URL . '/panels/admin/liquor.php');
    } else {
        $error = 'Liquor name cannot be empty.';
    }
}

ob_start();
?>
<h1><?= $id ? 'Edit' : 'Add' ?> Liquor</h1>
<?php if ($error): ?>
  <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
<?php endif; ?>
<form method="POST">
  <div class="mb-3">
    <label class="form-label">Liquor Name</label>
    <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($name) ?>" required>
  </div>
  <div class="mb-3">
    <label class="form-label">Brand</label>
    <select name="brand_id" class="form-select">
      <option value="">-- Select Brand --</option>
      <?php foreach ($brands as $b): ?>
        <option value="<?= $b['id'] ?>" <?= $b['id'] == $brand_id ? 'selected' : '' ?>><?= htmlspecialchars($b['name']) ?></option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="mb-3">
    <label class="form-label">Category</label>
    <select name="category_id" class="form-select">
      <option value="">-- Select Category --</option>
      <?php foreach ($categories as $c): ?>
        <option value="<?= $c['id'] ?>" <?= $c['id'] == $category_id ? 'selected' : '' ?>><?= htmlspecialchars($c['name']) ?></option>
      <?php endforeach; ?>
    </select>
  </div>
  <button class="btn btn-success"><?= $id ? 'Update' : 'Create' ?></button>
  <a href="<?= BASE_URL ?>/panels/admin/liquor.php" class="btn btn-secondary">Cancel</a>
</form>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
