<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'admin') redirect(BASE_URL . '/login.php');

// Initialize
$id = intval($_GET['id'] ?? 0);
$counter_id = 0;
$product_id = 0;
$quantity = '';
$error = '';

// Fetch lists
$counters = mysqli_fetch_all(mysqli_query($conn, "SELECT id, name FROM counters WHERE is_active = 1 ORDER BY name"), MYSQLI_ASSOC);
$products = mysqli_fetch_all(mysqli_query($conn, "SELECT id, name FROM products ORDER BY name"), MYSQLI_ASSOC);

// Load existing
if ($id) {
    $stmt = mysqli_prepare($conn, "SELECT counter_id, product_id, quantity FROM opening_stock WHERE id = ?");
    mysqli_stmt_bind_param($stmt, 'i', $id);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_bind_result($stmt, $counter_id, $product_id, $quantity);
    mysqli_stmt_fetch($stmt);
    mysqli_stmt_close($stmt);
}

// Handle POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $counter_id = intval($_POST['counter_id'] ?? 0);
    $product_id = intval($_POST['product_id'] ?? 0);
    $quantity = intval($_POST['quantity'] ?? 0);
    if (!$counter_id || !$product_id) {
        $error = 'Please select both counter and product.';
    } elseif ($quantity < 0) {
        $error = 'Quantity must be non-negative.';
    } else {
        if ($id) {
            $stmt = mysqli_prepare($conn, "UPDATE opening_stock SET counter_id = ?, product_id = ?, quantity = ? WHERE id = ?");
            mysqli_stmt_bind_param($stmt, 'iiii', $counter_id, $product_id, $quantity, $id);
        } else {
            $stmt = mysqli_prepare($conn, "INSERT INTO opening_stock (counter_id, product_id, quantity) VALUES (?, ?, ?)");
            mysqli_stmt_bind_param($stmt, 'iii', $counter_id, $product_id, $quantity);
        }
        mysqli_stmt_execute($stmt) or die('Error saving opening stock: ' . mysqli_error($conn));
        mysqli_stmt_close($stmt);
        // Reflect opening stock in counter_stock for POS visibility
        mysqli_query($conn, "INSERT INTO counter_stock (counter_id, product_id, quantity) VALUES ($counter_id, $product_id, $quantity) ON DUPLICATE KEY UPDATE quantity = VALUES(quantity)") or die('Error updating counter stock: '.mysqli_error($conn));
        redirect(BASE_URL . '/panels/admin/opening_stock.php');
    }
}

ob_start();
?>
<h1><?= $id ? 'Edit' : 'Add' ?> Opening Stock</h1>
<?php if ($error): ?>
  <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
<?php endif; ?>
<form method="POST">
  <div class="mb-3">
    <label class="form-label">Counter</label>
    <select name="counter_id" class="form-select" required>
      <option value="">-- Select Counter --</option>
      <?php foreach ($counters as $c): ?>
        <option value="<?= $c['id'] ?>"<?= $c['id'] == $counter_id ? ' selected' : '' ?>><?= htmlspecialchars($c['name']) ?></option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="mb-3">
    <label class="form-label">Product</label>
    <select name="product_id" class="form-select" required>
      <option value="">-- Select Product --</option>
      <?php foreach ($products as $p): ?>
        <option value="<?= $p['id'] ?>"<?= $p['id'] == $product_id ? ' selected' : '' ?>><?= htmlspecialchars($p['name']) ?></option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="mb-3">
    <label class="form-label">Quantity</label>
    <input type="number" name="quantity" class="form-control" value="<?= htmlspecialchars($quantity) ?>" min="0" required>
  </div>
  <button class="btn btn-success"><?= $id ? 'Update' : 'Create' ?></button>
  <a href="<?= BASE_URL ?>/panels/admin/opening_stock.php" class="btn btn-secondary">Cancel</a>
</form>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
