<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'admin') {
    redirect(BASE_URL . '/login.php');
}
// Fetch products with price & tax
$res = mysqli_query($conn, "SELECT id, name, price, tax FROM products ORDER BY name");
$items = mysqli_fetch_all($res, MYSQLI_ASSOC);

ob_start();
?>
<h1>Prices & Tax</h1>
<table class="table table-bordered table-striped">
  <thead>
    <tr>
      <th>ID</th><th>Name</th><th>Price</th><th>Tax %</th><th>Actions</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($items as $i): ?>
    <tr>
      <td><?= $i['id'] ?></td>
      <td><?= htmlspecialchars($i['name']) ?></td>
      <td><?= number_format($i['price'], 2) ?></td>
      <td><?= number_format($i['tax'], 2) ?></td>
      <td>
        <a href="<?= BASE_URL ?>/panels/admin/prices_tax_form.php?id=<?= $i['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
      </td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
