<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'admin') {
    redirect(BASE_URL . '/login.php');
}
// Handle delete
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    mysqli_query($conn, "DELETE FROM products WHERE id = $id");
    redirect(BASE_URL . '/panels/admin/products.php');
}
// Fetch products with relations
$res = mysqli_query($conn, 
    "SELECT p.id, p.name, b.name AS brand_name, c.name AS category_name, s.name AS size_name, p.price, p.tax 
     FROM products p
     LEFT JOIN brands b ON p.brand_id=b.id
     LEFT JOIN categories c ON p.category_id=c.id
     LEFT JOIN sizes s ON p.size_id=s.id
     ORDER BY p.name"
);
$products = mysqli_fetch_all($res, MYSQLI_ASSOC);
ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h1>Products</h1>
  <a href="<?= BASE_URL ?>/panels/admin/product_form.php" class="btn btn-primary">Add Product</a>
</div>
<table class="table table-bordered table-striped">
  <thead>
    <tr>
      <th>ID</th><th>Name</th><th>Brand</th><th>Category</th><th>Size</th><th>Price</th><th>Tax %</th><th>Actions</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($products as $p): ?>
    <tr>
      <td><?= $p['id'] ?></td>
      <td><?= htmlspecialchars($p['name'] ?? '') ?></td>
      <td><?= htmlspecialchars($p['brand_name'] ?? '') ?></td>
      <td><?= htmlspecialchars($p['category_name'] ?? '') ?></td>
      <td><?= htmlspecialchars($p['size_name'] ?? '') ?></td>
      <td><?= number_format($p['price'],2) ?></td>
      <td><?= number_format($p['tax'],2) ?></td>
      <td>
        <a href="<?= BASE_URL ?>/panels/admin/product_form.php?id=<?= $p['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
        <a href="<?= BASE_URL ?>/panels/admin/products.php?delete=<?= $p['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this product?')">Delete</a>
      </td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
