<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'admin') redirect(BASE_URL . '/login.php');

// Ensure purchases table exists
$createPurchases = "CREATE TABLE IF NOT EXISTS `purchases` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `supplier_id` INT UNSIGNED DEFAULT NULL,
  `purchase_date` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `total_amount` DECIMAL(10,2) NOT NULL,
  `created_by` INT UNSIGNED DEFAULT NULL,
  `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_pur_supplier` (`supplier_id`),
  KEY `fk_pur_user` (`created_by`),
  CONSTRAINT `fk_pur_supplier` FOREIGN KEY (`supplier_id`) REFERENCES `suppliers`(`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_pur_user` FOREIGN KEY (`created_by`) REFERENCES `users`(`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci";
mysqli_query($conn, $createPurchases) or die('Error creating purchases table: '.mysqli_error($conn));

// Conditional created_by join/display
$colRes = mysqli_query($conn, "SHOW COLUMNS FROM `purchases` LIKE 'created_by'") or die('Error checking created_by column: '.mysqli_error($conn));
$hasUserCol = mysqli_num_rows($colRes) > 0;

// Handle delete
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    mysqli_query($conn, "DELETE FROM purchases WHERE id = $id");
    redirect(BASE_URL . '/panels/admin/purchase_list.php');
}

// Build query
$userJoin = $hasUserCol ? ", u.username AS created_by" : "";
$userLeftJoin = $hasUserCol ? "LEFT JOIN users u ON p.created_by = u.id" : "";
$sql = "SELECT p.id, p.purchase_date, s.name AS supplier_name, p.total_amount{$userJoin}
        FROM purchases p
        LEFT JOIN suppliers s ON p.supplier_id = s.id
        {$userLeftJoin}
        ORDER BY p.purchase_date DESC";
$res = mysqli_query($conn, $sql) or die('Error fetching purchases: '.mysqli_error($conn));
$rows = mysqli_fetch_all($res, MYSQLI_ASSOC);

ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h1>Purchases</h1>
  <a href="<?= BASE_URL ?>/panels/admin/new_purchase.php" class="btn btn-primary">Add Purchase</a>
</div>
<table class="table table-bordered table-striped">
  <thead>
    <tr>
      <th>ID</th>
      <th>Date</th>
      <th>Supplier</th>
      <th>Total Amount</th>
      <?php if ($hasUserCol): ?><th>Created By</th><?php endif; ?>
      <th>Actions</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($rows as $r): ?>
    <tr>
      <td><?= $r['id'] ?></td>
      <td><?= htmlspecialchars($r['purchase_date']) ?></td>
      <td><?= htmlspecialchars($r['supplier_name'] ?? '') ?></td>
      <td><?= number_format($r['total_amount'],2) ?></td>
      <?php if ($hasUserCol): ?><td><?= htmlspecialchars($r['created_by'] ?? '') ?></td><?php endif; ?>
      <td>
        <a href="<?= BASE_URL ?>/panels/admin/purchase_list.php?delete=<?= $r['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this purchase?')">Delete</a>
      </td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
