<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'admin') redirect(BASE_URL . '/login.php');

// Handle delete
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    mysqli_query($conn, "DELETE FROM stock_adjustments WHERE id = $id");
    redirect(BASE_URL . '/panels/admin/stock_adjustments.php');
}

// Ensure stock_adjustments table exists
$check = mysqli_query($conn, "SHOW TABLES LIKE 'stock_adjustments'") or die('Error checking stock_adjustments table: '.mysqli_error($conn));
if (mysqli_num_rows($check) === 0) {
    $createSQL = 'CREATE TABLE `stock_adjustments` (
      `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
      `counter_id` INT UNSIGNED NOT NULL,
      `product_id` INT UNSIGNED NOT NULL,
      `adjustment_type` ENUM(\'in\',\'out\') NOT NULL,
      `quantity` INT NOT NULL,
      `remarks` TEXT,
      `created_by` INT UNSIGNED DEFAULT NULL,
      `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
      PRIMARY KEY (`id`),
      KEY `fk_sa_counter` (`counter_id`),
      KEY `fk_sa_product` (`product_id`),
      KEY `fk_sa_user` (`created_by`),
      CONSTRAINT `fk_sa_counter` FOREIGN KEY (`counter_id`) REFERENCES `counters`(`id`) ON DELETE CASCADE,
      CONSTRAINT `fk_sa_product` FOREIGN KEY (`product_id`) REFERENCES `products`(`id`) ON DELETE CASCADE,
      CONSTRAINT `fk_sa_user` FOREIGN KEY (`created_by`) REFERENCES `users`(`id`) ON DELETE SET NULL
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;';
    mysqli_query($conn, $createSQL) or die('Error creating stock_adjustments table: '.mysqli_error($conn));
}

// Fetch stock adjustments
$sql = "SELECT sa.id, c.name AS counter_name, p.name AS product_name, sa.adjustment_type, sa.quantity, sa.remarks, u.username AS created_by, sa.created_at
        FROM stock_adjustments sa
        LEFT JOIN counters c ON sa.counter_id = c.id
        LEFT JOIN products p ON sa.product_id = p.id
        LEFT JOIN users u ON sa.created_by = u.id
        ORDER BY sa.created_at DESC";
$res = mysqli_query($conn, $sql) or die('Error fetching stock adjustments: '.mysqli_error($conn));
$rows = mysqli_fetch_all($res, MYSQLI_ASSOC);

ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h1>Stock Adjustments</h1>
  <a href="<?= BASE_URL ?>/panels/admin/stock_adjustment_form.php" class="btn btn-primary">Add Adjustment</a>
</div>
<table class="table table-bordered table-striped">
  <thead>
    <tr><th>ID</th><th>Counter</th><th>Product</th><th>Type</th><th>Quantity</th><th>Remarks</th><th>Created By</th><th>Created At</th><th>Actions</th></tr>
  </thead>
  <tbody>
    <?php foreach ($rows as $r): ?>
    <tr>
      <td><?= $r['id'] ?></td>
      <td><?= htmlspecialchars($r['counter_name'] ?? '') ?></td>
      <td><?= htmlspecialchars($r['product_name'] ?? '') ?></td>
      <td><?= ucfirst($r['adjustment_type']) ?></td>
      <td><?= $r['quantity'] ?></td>
      <td><?= htmlspecialchars($r['remarks']) ?></td>
      <td><?= htmlspecialchars($r['created_by'] ?? '') ?></td>
      <td><?= $r['created_at'] ?></td>
      <td>
        <a href="<?= BASE_URL ?>/panels/admin/stock_adjustment_form.php?id=<?= $r['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
        <a href="<?= BASE_URL ?>/panels/admin/stock_adjustments.php?delete=<?= $r['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this adjustment?')">Delete</a>
      </td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
