<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'admin') redirect(BASE_URL . '/login.php');

// Get product ID
$productId = intval($_GET['id'] ?? 0);
if (!$productId) redirect(BASE_URL . '/panels/admin/stock_levels.php');

// Fetch product name
$stmt = mysqli_prepare($conn, "SELECT name FROM products WHERE id = ?");
mysqli_stmt_bind_param($stmt, 'i', $productId);
mysqli_stmt_execute($stmt);
mysqli_stmt_bind_result($stmt, $productName);
mysqli_stmt_fetch($stmt);
mysqli_stmt_close($stmt);

// Fetch existing stock
$res = mysqli_prepare($conn, "SELECT quantity FROM stock WHERE product_id = ?");
mysqli_stmt_bind_param($res, 'i', $productId);
mysqli_stmt_execute($res);
mysqli_stmt_bind_result($res, $oldQty);
if (!mysqli_stmt_fetch($res)) {
    $oldQty = 0;
}
mysqli_stmt_close($res);

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $newQty = intval($_POST['quantity']);
    if ($newQty < 0) {
        $error = 'Quantity must be non-negative.';
    } else {
        // Update or insert stock
        if ($oldQty !== null) {
            $stmt = mysqli_prepare($conn, "UPDATE stock SET quantity = ? WHERE product_id = ?");
            mysqli_stmt_bind_param($stmt, 'ii', $newQty, $productId);
        } else {
            $stmt = mysqli_prepare($conn, "INSERT INTO stock (product_id, quantity) VALUES (?, ?)");
            mysqli_stmt_bind_param($stmt, 'ii', $productId, $newQty);
        }
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);
        // Record movement
        $delta = $newQty - $oldQty;
        if ($delta !== 0) {
            $type = $delta > 0 ? 'in' : 'out';
            $qty = abs($delta);
            mysqli_query($conn, sprintf(
                "INSERT INTO stock_movements (product_id, counter_id, movement_type, quantity) VALUES (%d, NULL, '%s', %d)",
                $productId, $type, $qty
            ));
        }
        redirect(BASE_URL . '/panels/admin/stock_levels.php');
    }
}

ob_start();
?>
<h1>Edit Godown Stock for <?= htmlspecialchars($productName) ?></h1>
<?php if ($error): ?>
  <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
<?php endif; ?>
<form method="POST">
  <div class="mb-3">
    <label class="form-label">Quantity</label>
    <input type="number" name="quantity" class="form-control" value="<?= htmlspecialchars($oldQty) ?>" min="0" required>
  </div>
  <button class="btn btn-success">Save</button>
  <a href="<?= BASE_URL ?>/panels/admin/stock_levels.php" class="btn btn-secondary">Cancel</a>
</form>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
