<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'admin') redirect(BASE_URL . '/login.php');
// Fetch current godown stock per product
$sql = "SELECT p.id AS product_id, p.name AS product_name, COALESCE(s.quantity,0) AS quantity
        FROM products p
        LEFT JOIN stock s ON p.id = s.product_id
        ORDER BY p.name";
$res = mysqli_query($conn, $sql) or die('Error fetching stock levels: '.mysqli_error($conn));
$rows = mysqli_fetch_all($res, MYSQLI_ASSOC);
ob_start();
?>
<h1>Godown Stock Levels</h1>
<table class="table table-bordered table-striped">
  <thead>
    <tr><th>Product</th><th>Quantity</th><th>Action</th></tr>
  </thead>
  <tbody>
    <?php foreach ($rows as $r): ?>
    <tr>
      <td><?= htmlspecialchars($r['product_name']) ?></td>
      <td><?= $r['quantity'] ?></td>
      <td>
        <a href="<?= BASE_URL ?>/panels/admin/stock_form.php?id=<?= $r['product_id'] ?>" class="btn btn-sm btn-warning">Edit</a>
      </td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
