<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'admin') redirect(BASE_URL . '/login.php');

// Ensure stock_requests table exists
$create = "CREATE TABLE IF NOT EXISTS `stock_requests` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `counter_id` INT UNSIGNED DEFAULT NULL,
  `product_id` INT UNSIGNED NOT NULL,
  `quantity` INT NOT NULL,
  `remarks` TEXT,
  `status` ENUM('pending','approved','dispatched','rejected') NOT NULL DEFAULT 'pending',
  `created_by` INT UNSIGNED DEFAULT NULL,
  `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_sr_counter` (`counter_id`),
  KEY `fk_sr_product` (`product_id`),
  KEY `fk_sr_user` (`created_by`),
  CONSTRAINT `fk_sr_counter` FOREIGN KEY (`counter_id`) REFERENCES `counters`(`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_sr_product` FOREIGN KEY (`product_id`) REFERENCES `products`(`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_sr_user` FOREIGN KEY (`created_by`) REFERENCES `users`(`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci";
mysqli_query($conn, $create) or die('Error ensuring stock_requests table: '.mysqli_error($conn));

$cols = [
    'counter_id' => "INT UNSIGNED DEFAULT NULL",
    'product_id' => "INT UNSIGNED NOT NULL",
    'quantity'   => "INT NOT NULL DEFAULT 0",
    'remarks'    => "TEXT",
    'status'     => "ENUM('pending','approved','dispatched','rejected') NOT NULL DEFAULT 'pending'",
    'created_by' => "INT UNSIGNED DEFAULT NULL",
];
foreach ($cols as $colName => $colType) {
    $colCheck = mysqli_query($conn, "SHOW COLUMNS FROM `stock_requests` LIKE '$colName'") or die("Error checking $colName column: ".mysqli_error($conn));
    if (mysqli_num_rows($colCheck) === 0) {
        mysqli_query($conn, "ALTER TABLE `stock_requests` ADD COLUMN `$colName` $colType") or die("Error adding $colName column: ".mysqli_error($conn));
    }
}

// Handle approvals/rejections
if (isset($_GET['approve'])) {
    $id = intval($_GET['approve']);
    // Add requested stock to counter_stock
    $reqRes = mysqli_query($conn, "SELECT counter_id, product_id, quantity FROM stock_requests WHERE id = $id") or die('Error fetching request: '.mysqli_error($conn));
    if ($reqData = mysqli_fetch_assoc($reqRes)) {
        $cId = intval($reqData['counter_id']);
        $pId = intval($reqData['product_id']);
        $qty = intval($reqData['quantity']);
        mysqli_query($conn, "INSERT INTO counter_stock (counter_id, product_id, quantity) VALUES ($cId, $pId, $qty) ON DUPLICATE KEY UPDATE quantity = quantity + VALUES(quantity)") or die('Error updating counter stock: '.mysqli_error($conn));
    }
    mysqli_query($conn, "UPDATE stock_requests SET status='approved' WHERE id = $id") or die('Error approving request: '.mysqli_error($conn));
    redirect(BASE_URL . '/panels/admin/stock_requests_pending.php');
}
if (isset($_GET['reject'])) {
    $id = intval($_GET['reject']);
    mysqli_query($conn, "UPDATE stock_requests SET status='rejected' WHERE id = $id") or die('Error rejecting request: '.mysqli_error($conn));
    redirect(BASE_URL . '/panels/admin/stock_requests_pending.php');
}

// Fetch pending requests
// Check if quantity column exists
$qcol = mysqli_query($conn, "SHOW COLUMNS FROM `stock_requests` LIKE 'quantity'") or die('Error checking quantity: '.mysqli_error($conn));
$hasQty = mysqli_num_rows($qcol) > 0;
// Build fields
$fields = "sr.id";
if ($hasQty) { $fields .= ", sr.quantity"; } else { $fields .= ", 0 AS quantity"; }
$fields .= ", sr.remarks, sr.created_at, COALESCE(c.name,'') AS counter_name, COALESCE(p.name,'') AS product_name, COALESCE(u.username,'') AS requested_by";
$sql = "SELECT $fields
    FROM stock_requests sr
    LEFT JOIN counters c ON sr.counter_id = c.id
    LEFT JOIN products p ON sr.product_id = p.id
    LEFT JOIN users u ON sr.created_by = u.id
    WHERE sr.status = 'pending'
    ORDER BY sr.created_at DESC";
$res = mysqli_query($conn, $sql) or die('Error fetching pending requests: '.mysqli_error($conn));
$rows = mysqli_fetch_all($res, MYSQLI_ASSOC);

ob_start();
?>
<h1>Pending Stock Requests</h1>
<table class="table table-bordered table-striped">
  <thead>
    <tr>
      <th>ID</th>
      <th>Date</th>
      <th>Counter</th>
      <th>Product</th>
      <th>Quantity</th>
      <th>Remarks</th>
      <th>Requested By</th>
      <th>Actions</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($rows as $r): ?>
    <tr>
      <td><?= $r['id'] ?></td>
      <td><?= $r['created_at'] ?></td>
      <td><?= htmlspecialchars($r['counter_name']) ?></td>
      <td><?= htmlspecialchars($r['product_name']) ?></td>
      <td><?= $r['quantity'] ?></td>
      <td><?= htmlspecialchars($r['remarks']) ?></td>
      <td><?= htmlspecialchars($r['requested_by']) ?></td>
      <td>
        <a href="?approve=<?= $r['id'] ?>" class="btn btn-sm btn-success" onclick="return confirm('Approve this request?')">Approve</a>
        <a href="?reject=<?= $r['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Reject this request?')">Reject</a>
      </td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
