<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'admin') redirect(BASE_URL . '/login.php');

// Initialize
$id = intval($_GET['id'] ?? 0);
$name = '';
$contact = '';
$phone = '';
$email = '';
$address = '';
$error = '';

// Load existing for edit
if ($id) {
    $stmt = mysqli_prepare($conn, "SELECT name, contact_name, phone, email, address FROM suppliers WHERE id = ?");
    mysqli_stmt_bind_param($stmt, 'i', $id);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_bind_result($stmt, $name, $contact, $phone, $email, $address);
    mysqli_stmt_fetch($stmt);
    mysqli_stmt_close($stmt);
}

// Handle POST insert/update
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $contact = trim($_POST['contact_name'] ?? '');
    $phone = trim($_POST['phone'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $address = trim($_POST['address'] ?? '');

    if ($name === '') {
        $error = 'Supplier name is required.';
    } else {
        if ($id) {
            $stmt = mysqli_prepare($conn, "UPDATE suppliers SET name=?, contact_name=?, phone=?, email=?, address=? WHERE id=?");
            mysqli_stmt_bind_param($stmt, 'sssssi', $name, $contact, $phone, $email, $address, $id);
        } else {
            $stmt = mysqli_prepare($conn, "INSERT INTO suppliers (name, contact_name, phone, email, address) VALUES (?, ?, ?, ?, ?)");
            mysqli_stmt_bind_param($stmt, 'sssss', $name, $contact, $phone, $email, $address);
        }
        mysqli_stmt_execute($stmt) or die('Error saving supplier: '.mysqli_error($conn));
        mysqli_stmt_close($stmt);
        redirect(BASE_URL . '/panels/admin/suppliers.php');
    }
}

ob_start();
?>
<h1><?= $id ? 'Edit' : 'Add' ?> Supplier</h1>
<?php if ($error): ?>
  <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
<?php endif; ?>
<form method="POST">
  <div class="mb-3">
    <label class="form-label">Name</label>
    <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($name) ?>" required>
  </div>
  <div class="mb-3">
    <label class="form-label">Contact Name</label>
    <input type="text" name="contact_name" class="form-control" value="<?= htmlspecialchars($contact) ?>">
  </div>
  <div class="mb-3">
    <label class="form-label">Phone</label>
    <input type="text" name="phone" class="form-control" value="<?= htmlspecialchars($phone) ?>">
  </div>
  <div class="mb-3">
    <label class="form-label">Email</label>
    <input type="email" name="email" class="form-control" value="<?= htmlspecialchars($email) ?>">
  </div>
  <div class="mb-3">
    <label class="form-label">Address</label>
    <textarea name="address" class="form-control"><?= htmlspecialchars($address) ?></textarea>
  </div>
  <button class="btn btn-success"><?= $id ? 'Update' : 'Create' ?></button>
  <a href="<?= BASE_URL ?>/panels/admin/suppliers.php" class="btn btn-secondary">Cancel</a>
</form>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
