<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'admin') {
    redirect(BASE_URL . '/login.php');
}
// Handle delete
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    mysqli_query($conn, "DELETE FROM suppliers WHERE id = $id");
    redirect(BASE_URL . '/panels/admin/suppliers.php');
}
// Fetch suppliers
$result = mysqli_query($conn, "SELECT * FROM suppliers ORDER BY name");
$suppliers = mysqli_fetch_all($result, MYSQLI_ASSOC);
ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h1>Suppliers</h1>
  <a href="<?= BASE_URL ?>/panels/admin/supplier_form.php" class="btn btn-primary">Add Supplier</a>
</div>
<table class="table table-bordered table-striped">
  <thead>
    <tr>
      <th>ID</th><th>Name</th><th>Contact</th><th>Phone</th><th>Email</th><th>Address</th><th>Actions</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($suppliers as $s): ?>
    <tr>
      <td><?= $s['id'] ?></td>
      <td><?= htmlspecialchars($s['name']) ?></td>
      <td><?= htmlspecialchars($s['contact_name']) ?></td>
      <td><?= htmlspecialchars($s['phone']) ?></td>
      <td><?= htmlspecialchars($s['email']) ?></td>
      <td><?= htmlspecialchars($s['address']) ?></td>
      <td>
        <a href="<?= BASE_URL ?>/panels/admin/supplier_form.php?id=<?= $s['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
        <a href="<?= BASE_URL ?>/panels/admin/suppliers.php?delete=<?= $s['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this supplier?')">Delete</a>
      </td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
