<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'admin') redirect(BASE_URL . '/login.php');

$id = intval($_GET['id'] ?? 0);
$floor_id = '';
$table_number = '';
$capacity = 1;
$error = '';

// Fetch floors for dropdown
$floorsRes = mysqli_query($conn, "SELECT id, name FROM floors ORDER BY name");
$floorList = mysqli_fetch_all($floorsRes, MYSQLI_ASSOC);

if ($id) {
    $stmt = mysqli_prepare($conn, "SELECT floor_id, table_number, capacity FROM `tables` WHERE id = ?");
    mysqli_stmt_bind_param($stmt, 'i', $id);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_bind_result($stmt, $floor_id, $table_number, $capacity);
    mysqli_stmt_fetch($stmt);
    mysqli_stmt_close($stmt);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $floor_id = intval($_POST['floor_id'] ?? 0);
    $table_number = trim($_POST['table_number'] ?? '');
    $capacity = intval($_POST['capacity'] ?? 1);
    if ($floor_id && $table_number) {
        if ($id) {
            $stmt = mysqli_prepare($conn, "UPDATE `tables` SET floor_id = ?, table_number = ?, capacity = ? WHERE id = ?");
            mysqli_stmt_bind_param($stmt, 'isii', $floor_id, $table_number, $capacity, $id);
        } else {
            $stmt = mysqli_prepare($conn, "INSERT INTO `tables` (floor_id, table_number, capacity) VALUES (?, ?, ?)");
            mysqli_stmt_bind_param($stmt, 'isi', $floor_id, $table_number, $capacity);
        }
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);
        redirect(BASE_URL . '/panels/admin/tables.php');
    } else {
        $error = 'Please select floor and enter table number.';
    }
}

ob_start();
?>
<h1><?= $id ? 'Edit' : 'Add' ?> Table</h1>
<?php if ($error): ?>
  <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
<?php endif; ?>
<form method="POST">
  <div class="mb-3">
    <label class="form-label">Floor</label>
    <select name="floor_id" class="form-select" required>
      <option value="">Select Floor</option>
      <?php foreach ($floorList as $f): ?>
        <option value="<?= $f['id'] ?>" <?= $f['id'] == $floor_id ? 'selected' : '' ?>><?= htmlspecialchars($f['name']) ?></option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="mb-3">
    <label class="form-label">Table Number</label>
    <input type="text" name="table_number" class="form-control" value="<?= htmlspecialchars($table_number) ?>" required>
  </div>
  <div class="mb-3">
    <label class="form-label">Capacity</label>
    <input type="number" name="capacity" class="form-control" value="<?= intval($capacity) ?>" min="1" required>
  </div>
  <button class="btn btn-success"><?= $id ? 'Update' : 'Create' ?></button>
  <a href="<?= BASE_URL ?>/panels/admin/tables.php" class="btn btn-secondary">Cancel</a>
</form>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
