<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'admin') redirect(BASE_URL . '/login.php');

// Handle delete
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    mysqli_query($conn, "DELETE FROM users WHERE id = $id");
    redirect(BASE_URL . '/panels/admin/users.php');
}

// Fetch users with assigned counter names
$query = "SELECT u.id, u.username, u.role, u.full_name, u.email, u.assigned_counter_id, c.name AS counter_name, u.created_at
          FROM users u
          LEFT JOIN counters c ON u.assigned_counter_id = c.id
          ORDER BY u.username";
$res = mysqli_query($conn, $query);
$users = mysqli_fetch_all($res, MYSQLI_ASSOC);

ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h1>Users</h1>
  <a href="<?= BASE_URL ?>/panels/admin/user_form.php" class="btn btn-primary">Add User</a>
</div>
<table class="table table-bordered table-striped">
  <thead>
    <tr>
      <th>ID</th>
      <th>Username</th>
      <th>Full Name</th>
      <th>Email</th>
      <th>Role</th>
      <th>Counter</th>
      <th>Created At</th>
      <th>Actions</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($users as $u): ?>
    <tr>
      <td><?= $u['id'] ?></td>
      <td><?= htmlspecialchars($u['username']) ?></td>
      <td><?= htmlspecialchars($u['full_name']) ?></td>
      <td><?= htmlspecialchars($u['email']) ?></td>
      <td><?= htmlspecialchars(ucfirst($u['role'])) ?></td>
      <td><?= $u['counter_name'] ?? '—' ?></td>
      <td><?= $u['created_at'] ?></td>
      <td>
        <a href="<?= BASE_URL ?>/panels/admin/user_form.php?id=<?= $u['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
        <a href="<?= BASE_URL ?>/panels/admin/users.php?delete=<?= $u['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this user?')">Delete</a>
      </td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
