<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'manager') redirect(BASE_URL . '/login.php');
// Assigned counter
$res = mysqli_query($conn, "SELECT assigned_counter_id FROM users WHERE id={$_SESSION['user_id']}");
$row = mysqli_fetch_assoc($res);
$counterID = intval($row['assigned_counter_id'] ?? 0);
// Fetch users for filter
$usersRes = mysqli_query($conn, "SELECT id, username, full_name FROM users WHERE assigned_counter_id=$counterID ORDER BY username");
// Filters
$from = $_GET['from'] ?? '';
$to = $_GET['to'] ?? '';
$user_id = intval($_GET['user_id'] ?? 0);
// Build where clauses
$where = ["u.assigned_counter_id = $counterID"];
if ($user_id)    $where[] = "al.user_id = $user_id";
if ($from)       $where[] = "al.created_at >= '" . mysqli_real_escape_string($conn, $from . " 00:00:00") . "'";
if ($to)         $where[] = "al.created_at <= '" . mysqli_real_escape_string($conn, $to . " 23:59:59") . "'";
$w = $where ? 'WHERE ' . implode(' AND ', $where) : '';
// Query logs
$sql = "SELECT al.created_at, u.username, u.full_name, al.action
        FROM audit_logs al
        JOIN users u ON al.user_id = u.id
        $w
        ORDER BY al.created_at DESC";
$res = mysqli_query($conn, $sql) or die(mysqli_error($conn));
$data = mysqli_fetch_all($res, MYSQLI_ASSOC);
// Export CSV
if (isset($_GET['export']) && $_GET['export'] === 'csv') {
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="activities_log.csv"');
    $out = fopen('php://output', 'w');
    if (!empty($data)) fputcsv($out, array_keys($data[0]));
    foreach ($data as $row) fputcsv($out, $row);
    exit;
}
ob_start();
?>
<h1 class="h2 mb-4">Activities Log</h1>
<form method="GET" class="row g-3 mb-4">
  <div class="col-md-2">
    <input type="date" name="from" value="<?= htmlspecialchars($from) ?>" class="form-control" placeholder="From">
  </div>
  <div class="col-md-2">
    <input type="date" name="to"   value="<?= htmlspecialchars($to) ?>"   class="form-control" placeholder="To">
  </div>
  <div class="col-md-3">
    <select name="user_id" class="form-select">
      <option value="">All Users</option>
      <?php while ($u = mysqli_fetch_assoc($usersRes)): ?>
      <option value="<?= $u['id'] ?>" <?= $u['id'] === $user_id ? 'selected' : '' ?>><?= htmlspecialchars($u['username']) ?></option>
      <?php endwhile; ?>
    </select>
  </div>
  <div class="col-md-5 text-end">
    <button class="btn btn-primary">Filter</button>
    <a href="?<?= htmlspecialchars(http_build_query(['from'=>$from,'to'=>$to,'user_id'=>$user_id])) ?>&export=csv" class="btn btn-secondary">Export CSV</a>
  </div>
</form>
<table class="table table-striped">
  <thead>
    <tr><th>Date</th><th>User</th><th>Full Name</th><th>Action</th></tr>
  </thead>
  <tbody>
    <?php foreach ($data as $r): ?>
    <tr>
      <td><?= $r['created_at'] ?></td>
      <td><?= htmlspecialchars($r['username']) ?></td>
      <td><?= htmlspecialchars($r['full_name']) ?></td>
      <td><?= htmlspecialchars($r['action']) ?></td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
