<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'manager') redirect(BASE_URL . '/login.php');
// Get assigned counter
$res = mysqli_query($conn, "SELECT assigned_counter_id FROM users WHERE id = {$_SESSION['user_id']}");
$row = mysqli_fetch_assoc($res);
$counterID = intval($row['assigned_counter_id'] ?? 0);
// Get counter name
$res2 = mysqli_query($conn, "SELECT name FROM counters WHERE id = $counterID");
$counterName = mysqli_fetch_assoc($res2)['name'] ?? 'N/A';
// Fetch metrics
$res = mysqli_query($conn, "SELECT SUM(total_amount) AS total FROM sales WHERE DATE(sale_date)=CURDATE() AND counter_id=$counterID");
$todaySales = floatval(mysqli_fetch_assoc($res)['total'] ?? 0);
$res = mysqli_query($conn, "SELECT SUM(quantity) AS qty FROM counter_stock WHERE counter_id=$counterID");
$stockQty = intval(mysqli_fetch_assoc($res)['qty'] ?? 0);
$res = mysqli_query($conn, "SELECT COUNT(*) AS cnt FROM stock_requests WHERE status='pending' AND counter_id=$counterID");
$pendingReq = intval(mysqli_fetch_assoc($res)['cnt'] ?? 0);
$res = mysqli_query($conn, "SELECT COUNT(*) AS cnt FROM dispatches d JOIN stock_requests sr ON d.stock_request_id=sr.id WHERE DATE(dispatched_at)=CURDATE() AND sr.counter_id=$counterID");
$receivedDispatch = intval(mysqli_fetch_assoc($res)['cnt'] ?? 0);
$res = mysqli_query($conn, "SELECT COUNT(*) AS cnt FROM counter_stock WHERE counter_id=$counterID AND quantity < 10");
$lowStock = intval(mysqli_fetch_assoc($res)['cnt'] ?? 0);
// Sales trend last 7 days
$sqlTrend = "SELECT DATE(sale_date) AS dt, SUM(total_amount) AS total FROM sales WHERE counter_id=$counterID AND sale_date >= DATE_SUB(CURDATE(), INTERVAL 6 DAY) GROUP BY DATE(sale_date) ORDER BY DATE(sale_date)";
$res = mysqli_query($conn, $sqlTrend);
$trend = [];
while($r = mysqli_fetch_assoc($res)) $trend[] = $r;
ob_start();
?>
<div class="d-flex justify-content-between flex-wrap mb-4">
  <h1 class="h2">Manager Dashboard</h1>
  <small class="text-muted">Counter: <?= htmlspecialchars($counterName) ?></small>
</div>
<div class="row g-3">
  <?php $widgets = [
    ['icon'=>'fa-chart-line','value'=>$todaySales,'label'=>'Today\'s Sales','color'=>'primary'],
    ['icon'=>'fa-box','value'=>$stockQty,'label'=>'Stock Available','color'=>'success'],
    ['icon'=>'fa-clock','value'=>$pendingReq,'label'=>'Pending Requests','color'=>'warning'],
    ['icon'=>'fa-truck','value'=>$receivedDispatch,'label'=>'Received Dispatches','color'=>'info'],
    ['icon'=>'fa-exclamation-triangle','value'=>$lowStock,'label'=>'Low Stock Alerts','color'=>'danger'],
  ]; ?>
  <?php foreach($widgets as $w): ?>
  <div class="col-6 col-md-4 col-lg-2">
    <div class="card text-center">
      <div class="card-body">
        <div class="widget-icon-wrapper bg-<?= $w['color'] ?> mx-auto mb-3">
          <i class="fas <?= $w['icon'] ?> text-white"></i>
        </div>
        <h3><?= $w['value'] ?></h3>
        <p class="mb-0"><?= $w['label'] ?></p>
      </div>
    </div>
  </div>
  <?php endforeach; ?>
</div>
<div class="card mt-4">
  <div class="card-body">
    <h5>Sales Trend (Last 7 Days)</h5>
    <canvas id="salesTrend"></canvas>
  </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
const labels = <?= json_encode(array_column($trend,'dt')) ?>;
const data = <?= json_encode(array_map(fn($r)=>floatval($r['total']), $trend)) ?>;
new Chart(document.getElementById('salesTrend'), {type:'line',data:{labels,datasets:[{label:'Sales',data,borderColor:'#4e73df',backgroundColor:'rgba(78,115,223,0.1)',tension:0.2}]},options:{scales:{y:{beginAtZero:true}}}});
</script>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
