<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'manager') redirect(BASE_URL . '/login.php');

// Assigned counter
$res = mysqli_query($conn, "SELECT assigned_counter_id FROM users WHERE id={$_SESSION['user_id']}");
$counterID = intval(mysqli_fetch_assoc($res)['assigned_counter_id'] ?? 0);

// Ensure feedback table exists
$create = "CREATE TABLE IF NOT EXISTS manager_feedback (
  id INT UNSIGNED NOT NULL AUTO_INCREMENT,
  counter_id INT UNSIGNED NOT NULL,
  manager_id INT UNSIGNED NOT NULL,
  target_user_id INT UNSIGNED NOT NULL,
  feedback_text TEXT NOT NULL,
  escalate TINYINT(1) NOT NULL DEFAULT 0,
  created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  KEY fk_mf_manager (manager_id),
  KEY fk_mf_target (target_user_id),
  KEY fk_mf_counter (counter_id),
  CONSTRAINT fk_mf_manager FOREIGN KEY (manager_id) REFERENCES users(id) ON DELETE CASCADE,
  CONSTRAINT fk_mf_target FOREIGN KEY (target_user_id) REFERENCES users(id) ON DELETE CASCADE,
  CONSTRAINT fk_mf_counter FOREIGN KEY (counter_id) REFERENCES counters(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
mysqli_query($conn, $create) or die(mysqli_error($conn));

// Preserve form values
$target = intval($_POST['target_user_id'] ?? 0);
$text   = trim($_POST['feedback_text'] ?? '');
$esc    = isset($_POST['escalate']) ? 1 : 0;

// Handle submission
$errors = [];
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!$target) $errors[] = 'Select a user.';
    if ($text === '') $errors[] = 'Feedback cannot be empty.';
    if (empty($errors)) {
        mysqli_query($conn, "INSERT INTO manager_feedback (counter_id, manager_id, target_user_id, feedback_text, escalate) VALUES ($counterID, {$_SESSION['user_id']}, $target, '".mysqli_real_escape_string($conn,$text)."', $esc)") or die(mysqli_error($conn));
        redirect(BASE_URL . '/panels/manager/feedback.php');
    }
}

// Fetch users for selection
$usersRes = mysqli_query($conn, "SELECT id, username, full_name FROM users WHERE assigned_counter_id=$counterID ORDER BY username");
// Fetch existing feedbacks
$fbRes = mysqli_query($conn,
    "SELECT f.id, u.username, u.full_name, f.feedback_text, f.escalate, f.created_at
     FROM manager_feedback f
     JOIN users u ON f.target_user_id=u.id
     WHERE f.counter_id=$counterID
     ORDER BY f.created_at DESC"
) or die(mysqli_error($conn));

ob_start();
?>
<h1 class="h2 mb-4">Submit Feedback</h1>
<?php if ($errors): foreach ($errors as $e): ?>
  <div class="alert alert-danger"><?= htmlspecialchars($e) ?></div>
<?php endforeach; endif; ?>
<div class="card mb-4"><div class="card-body">
  <form method="POST" class="row g-3">
    <div class="col-md-4">
      <label class="form-label">User</label>
      <select name="target_user_id" class="form-select" required>
        <option value="">Select User</option>
        <?php while($u = mysqli_fetch_assoc($usersRes)): ?>
        <option value="<?= $u['id'] ?>"><?= htmlspecialchars($u['username'] . ' (' . $u['full_name'] . ')') ?></option>
        <?php endwhile; ?>
      </select>
    </div>
    <div class="col-md-6">
      <label class="form-label">Feedback</label>
      <textarea name="feedback_text" class="form-control" rows="2" required><?= htmlspecialchars($text) ?></textarea>
    </div>
    <div class="col-md-2 align-self-end">
      <div class="form-check mb-2">
        <input type="checkbox" name="escalate" class="form-check-input" id="escalateCheck" <?= $esc ? 'checked' : '' ?>>
        <label class="form-check-label" for="escalateCheck">Escalate</label>
      </div>
      <button type="submit" class="btn btn-primary">Submit</button>
    </div>
  </form>
</div></div>
<h2 class="h4 mb-3">Previous Feedback</h2>
<table class="table table-striped">
  <thead><tr><th>ID</th><th>User</th><th>Feedback</th><th>Escalated</th><th>Date</th></tr></thead>
  <tbody>
    <?php while($f = mysqli_fetch_assoc($fbRes)): ?>
    <tr>
      <td><?= $f['id'] ?></td>
      <td><?= htmlspecialchars($f['username']) ?></td>
      <td><?= htmlspecialchars($f['feedback_text']) ?></td>
      <td><?= $f['escalate'] ? 'Yes' : 'No' ?></td>
      <td><?= $f['created_at'] ?></td>
    </tr>
    <?php endwhile; ?>
  </tbody>
</table>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
