<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'manager') redirect(BASE_URL . '/login.php');
// Assigned counter
$res = mysqli_query($conn, "SELECT assigned_counter_id FROM users WHERE id={$_SESSION['user_id']}");
$counterID = intval(mysqli_fetch_assoc($res)['assigned_counter_id'] ?? 0);
// Ensure validation columns
$cols = [
    'validation_status' => "ENUM('pending','validated','disputed') NOT NULL DEFAULT 'pending'",
    'manager_remarks'   => 'TEXT',
    'validated_by'      => 'INT UNSIGNED',
    'validated_at'      => 'DATETIME'
];
foreach ($cols as $col => $def) {
    $chk = mysqli_query($conn, "SHOW COLUMNS FROM `day_opening_stock` LIKE '$col'");
    if (mysqli_num_rows($chk) === 0) {
        mysqli_query($conn, "ALTER TABLE `day_opening_stock` ADD COLUMN `$col` $def") or die(mysqli_error($conn));
    }
}
// Handle actions
if (isset($_GET['action'], $_GET['id'])) {
    $id = intval($_GET['id']);
    $act = $_GET['action'] === 'validate' ? 'validated' : 'disputed';
    $remarks = mysqli_real_escape_string($conn, $_GET['remarks'] ?? '');
    $now = date('Y-m-d H:i:s');
    mysqli_query($conn, 
      "UPDATE day_opening_stock SET validation_status='$act', manager_remarks='$remarks', validated_by={$_SESSION['user_id']}, validated_at='$now' WHERE id=$id"
    ) or die(mysqli_error($conn));
    redirect(BASE_URL . '/panels/manager/opening_stock_summary.php');
}
// Fetch today's openings
$today = date('Y-m-d');
$sql = "SELECT ds.id, p.name AS product, ds.quantity, ds.opened_at, ds.validation_status, ds.manager_remarks, ds.validated_at, u.full_name AS validated_by
        FROM day_opening_stock ds
        JOIN products p ON ds.product_id=p.id
        LEFT JOIN users u ON ds.validated_by=u.id
        WHERE ds.counter_id=$counterID AND DATE(ds.opened_at)='$today'
        ORDER BY ds.opened_at DESC";
$res = mysqli_query($conn, $sql) or die(mysqli_error($conn));
$data = mysqli_fetch_all($res, MYSQLI_ASSOC);
ob_start();
?>
<h1 class="h2 mb-4">Opening Stock Summary</h1>
<table class="table table-striped">
  <thead>
    <tr><th>ID</th><th>Product</th><th>Qty</th><th>Opened At</th><th>Status</th><th>Remarks</th><th>Validated At</th><th>Action</th></tr>
  </thead>
  <tbody>
    <?php foreach ($data as $r): ?>
    <tr>
      <td><?= $r['id'] ?></td>
      <td><?= htmlspecialchars($r['product']) ?></td>
      <td><?= $r['quantity'] ?></td>
      <td><?= $r['opened_at'] ?></td>
      <td><?= ucfirst($r['validation_status']) ?></td>
      <td><?= htmlspecialchars($r['manager_remarks']) ?></td>
      <td><?= $r['validated_at'] ?? '-' ?></td>
      <td>
        <?php if ($r['validation_status'] === 'pending'): ?>
          <a href="?action=validate&id=<?= $r['id'] ?>" class="btn btn-sm btn-success">Validate</a>
          <a href="#" class="btn btn-sm btn-warning" onclick="handleDispute(<?= $r['id'] ?>)">Dispute</a>
        <?php else: ?>
          <span class="text-muted">-</span>
        <?php endif; ?>
      </td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<script>
function handleDispute(id) {
  let remarks = prompt('Enter remarks for dispute:');
  if (remarks !== null) {
    window.location = '?action=dispute&id=' + id + '&remarks=' + encodeURIComponent(remarks);
  }
}
</script>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
