<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'manager') redirect(BASE_URL . '/login.php');
// Assigned counter
$res = mysqli_query($conn, "SELECT assigned_counter_id FROM users WHERE id={$_SESSION['user_id']}");
$counterID = intval(mysqli_fetch_assoc($res)['assigned_counter_id'] ?? 0);
// Filters
$from = $_GET['from'] ?? '';
$to = $_GET['to'] ?? '';
$where = ["counter_id=$counterID"];
if ($from) $where[] = "DATE(sale_date)>= '".mysqli_real_escape_string($conn,$from)."'";
if ($to) $where[] = "DATE(sale_date)<= '".mysqli_real_escape_string($conn,$to)."'";
$w = implode(' AND ',$where);
// Fetch summary
$sql = "SELECT DATE(sale_date) AS date, SUM(total_amount) AS total FROM sales WHERE $w GROUP BY DATE(sale_date) ORDER BY date DESC";
$res = mysqli_query($conn,$sql) or die(mysqli_error($conn));
$data = mysqli_fetch_all($res,MYSQLI_ASSOC);
// Export CSV
if (isset($_GET['export']) && $_GET['export']==='csv') {
  header('Content-Type:text/csv');
  header('Content-Disposition:attachment;filename="sales_summary.csv"');
  $out = fopen('php://output','w');
  if ($data) fputcsv($out,array_keys($data[0]));
  foreach($data as $row) fputcsv($out,$row);
  exit;
}
ob_start();
?>
<h1 class="h2 mb-4">Counter-wise Sales Summary</h1>
<form method="GET" class="row g-3 mb-4">
  <div class="col-md-3"><input type="date" name="from" value="<?=htmlspecialchars($from)?>" class="form-control"></div>
  <div class="col-md-3"><input type="date" name="to"   value="<?=htmlspecialchars($to)?>" class="form-control"></div>
  <div class="col-md-6">
    <button class="btn btn-primary">Filter</button>
    <a href="?<?=htmlspecialchars($_SERVER['QUERY_STRING'])?>&export=csv" class="btn btn-secondary">Export CSV</a>
  </div>
</form>
<table class="table table-striped">
  <thead><tr><th>Date</th><th>Total Sales</th></tr></thead>
  <tbody>
  <?php foreach($data as $r):?>
    <tr><td><?=$r['date']?></td><td><?=number_format($r['total'],2)?></td></tr>
  <?php endforeach;?>
  </tbody>
</table>
<?php
$content=ob_get_clean();
require_once __DIR__.'/../../includes/layout.php';
?>
