<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'manager') redirect(BASE_URL . '/login.php');
// Get manager's counter
$res = mysqli_query($conn, "SELECT assigned_counter_id FROM users WHERE id={$_SESSION['user_id']}");
$counterID = intval(mysqli_fetch_assoc($res)['assigned_counter_id'] ?? 0);
// Ensure table exists
$create = "CREATE TABLE IF NOT EXISTS counter_stock_adjustments (
  id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
  counter_id INT UNSIGNED NOT NULL,
  product_id INT UNSIGNED NOT NULL,
  quantity INT NOT NULL,
  reason TEXT NOT NULL,
  status ENUM('pending','approved','rejected') NOT NULL DEFAULT 'pending',
  created_by INT UNSIGNED NOT NULL,
  created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB CHARSET=utf8mb4";
mysqli_query($conn, $create) or die(mysqli_error($conn));
// Handle submission
$errors = [];
if ($_SERVER['REQUEST_METHOD']==='POST') {
    $pid = intval($_POST['product_id'] ?? 0);
    $qty = intval($_POST['quantity'] ?? 0);
    $reason = trim($_POST['reason'] ?? '');
    if (!$pid) $errors[] = 'Select product.';
    if ($qty<=0) $errors[] = 'Quantity must be positive.';
    if ($reason==='') $errors[] = 'Reason required.';
    if (!$errors) {
        mysqli_query($conn, "INSERT INTO counter_stock_adjustments (counter_id,product_id,quantity,reason,created_by) VALUES ($counterID,$pid,$qty,'".mysqli_real_escape_string($conn,$reason)."',{$_SESSION['user_id']})") or die(mysqli_error($conn));
        redirect(BASE_URL . '/panels/manager/stock_adjustment_requests.php');
    }
}
// Fetch adjustments
$sql = "SELECT a.id, p.name product, a.quantity, a.reason, a.status, a.created_at
        FROM counter_stock_adjustments a
        JOIN products p ON a.product_id=p.id
        WHERE a.counter_id=$counterID ORDER BY a.created_at DESC";
$data = mysqli_query($conn,$sql) or die(mysqli_error($conn));
ob_start();
?>
<h1 class="h2 mb-4">Stock Adjustment Requests</h1>
<?php if($errors): ?><div class="alert alert-danger"><?= htmlspecialchars(implode('<br>',$errors)) ?></div><?php endif; ?>
<div class="card mb-4"><div class="card-body">
  <form method="POST" class="row g-3">
    <div class="col-md-4">
      <label class="form-label">Product</label>
      <select name="product_id" class="form-select" required>
        <option value="">Select</option>
<?php $pr = mysqli_query($conn,"SELECT id,name FROM products ORDER BY name"); while($p=mysqli_fetch_assoc($pr)): ?>
        <option value="<?= $p['id'] ?>"><?= htmlspecialchars($p['name']) ?></option>
<?php endwhile; ?>
      </select>
    </div>
    <div class="col-md-2">
      <label class="form-label">Qty</label>
      <input type="number" name="quantity" min="1" class="form-control" required>
    </div>
    <div class="col-md-4">
      <label class="form-label">Reason</label>
      <input type="text" name="reason" class="form-control" required>
    </div>
    <div class="col-md-2 align-self-end">
      <button type="submit" class="btn btn-primary">Submit</button>
    </div>
  </form>
</div></div>
<table class="table table-striped">
  <thead><tr><th>ID</th><th>Product</th><th>Qty</th><th>Reason</th><th>Status</th><th>Date</th></tr></thead>
  <tbody>
<?php while($r=mysqli_fetch_assoc($data)): ?>
<tr>
  <td><?= $r['id'] ?></td>
  <td><?= htmlspecialchars($r['product']) ?></td>
  <td><?= $r['quantity'] ?></td>
  <td><?= htmlspecialchars($r['reason']) ?></td>
  <td><?= ucfirst($r['status']) ?></td>
  <td><?= $r['created_at'] ?></td>
</tr>
<?php endwhile; ?>
  </tbody>
</table>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
