<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'sales') redirect(BASE_URL . '/login.php');
$user_id = $_SESSION['user_id'];
$message = '';
$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $old = $_POST['old_password'] ?? '';
    $new = $_POST['new_password'] ?? '';
    $confirm = $_POST['confirm_password'] ?? '';
    if (!$old || !$new || !$confirm) {
        $error = 'All fields are required.';
    } elseif ($new !== $confirm) {
        $error = 'New passwords do not match.';
    } else {
        $res = mysqli_query($conn, "SELECT password FROM users WHERE id=$user_id");
        $row = mysqli_fetch_assoc($res);
        $hash = $row['password'] ?? '';
        if (!password_verify($old, $hash)) {
            $error = 'Current password is incorrect.';
        } else {
            $newHash = password_hash($new, PASSWORD_DEFAULT);
            if (mysqli_query($conn, "UPDATE users SET password='$newHash' WHERE id=$user_id")) {
                $message = 'Password changed successfully.';
            } else {
                $error = 'Error updating password: ' . mysqli_error($conn);
            }
        }
    }
}
ob_start();
?>
<h1 class="h2 mb-4">Change Password</h1>
<?php if ($message): ?><div class="alert alert-success"><?= $message ?></div><?php endif; ?>
<?php if ($error): ?><div class="alert alert-danger"><?= $error ?></div><?php endif; ?>
<form method="post">
  <div class="mb-3">
    <label class="form-label">Current Password</label>
    <input type="password" name="old_password" class="form-control" required>
  </div>
  <div class="mb-3">
    <label class="form-label">New Password</label>
    <input type="password" name="new_password" class="form-control" required>
  </div>
  <div class="mb-3">
    <label class="form-label">Confirm Password</label>
    <input type="password" name="confirm_password" class="form-control" required>
  </div>
  <button type="submit" class="btn btn-primary">Change Password</button>
</form>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
