<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'sales') redirect(BASE_URL . '/login.php');
// Assigned counter
$res = mysqli_query($conn, "SELECT assigned_counter_id FROM users WHERE id={$_SESSION['user_id']}");
$counterID = intval(mysqli_fetch_assoc($res)['assigned_counter_id'] ?? 0);
// Fetch current stock
$sql = "SELECT p.id, p.name, c.name AS category, s.name AS size, p.price, cs.quantity, cs.last_updated 
    FROM counter_stock cs 
    JOIN products p ON cs.product_id=p.id 
    LEFT JOIN categories c ON p.category_id=c.id 
    LEFT JOIN sizes s ON p.size_id=s.id 
    WHERE cs.counter_id=$counterID";
$ret = mysqli_query($conn, $sql);
$stocks = mysqli_fetch_all($ret, MYSQLI_ASSOC);
ob_start();
?>
<h1 class="h2 mb-4">Current Stock</h1>
<div class="mb-3">
  <a href="<?= BASE_URL ?>/panels/sales/request_stock.php" class="btn btn-primary btn-sm">New Request</a>
  <a href="<?= BASE_URL ?>/panels/sales/stock_history.php" class="btn btn-secondary btn-sm ms-2">History</a>
</div>
<div class="mb-3">
  <input type="text" id="stockSearch" class="form-control w-25" placeholder="Search stock...">
</div>
<table class="table table-striped" id="stockTable">
  <thead>
    <tr>
      <th>Product</th>
      <th>Category</th>
      <th>Size</th>
      <th>Price</th>
      <th>Quantity</th>
      <th>Last Updated</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach($stocks as $st): ?>
    <tr>
      <td><?= htmlspecialchars($st['name']) ?></td>
      <td><?= htmlspecialchars($st['category']) ?></td>
      <td><?= htmlspecialchars($st['size']) ?></td>
      <td><?= number_format($st['price'],2) ?></td>
      <td><?= intval($st['quantity']) ?></td>
      <td><?= htmlspecialchars($st['last_updated']) ?></td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<script>
document.getElementById('stockSearch').addEventListener('input', function(e) {
  const term = e.target.value.toLowerCase();
  document.querySelectorAll('#stockTable tbody tr').forEach(tr => {
    tr.style.display = tr.textContent.toLowerCase().includes(term) ? '' : 'none';
  });
});
</script>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
