<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'sales') redirect(BASE_URL . '/login.php');

// Assigned counter
$res = mysqli_query($conn, "SELECT assigned_counter_id FROM users WHERE id={$_SESSION['user_id']}");
$counterID = intval(mysqli_fetch_assoc($res)['assigned_counter_id'] ?? 0);

// Get sale ID
$saleId = intval($_GET['id'] ?? 0);
if ($saleId <= 0) {
    redirect(BASE_URL . '/panels/sales/sales_history.php');
}

// Fetch sale header
$sq = "SELECT s.id, s.sale_date, s.total_amount, s.payment_mode, u.full_name, c.name AS counter_name
        FROM sales s
        LEFT JOIN users u ON s.created_by=u.id
        LEFT JOIN counters c ON s.counter_id=c.id
        WHERE s.id=$saleId AND s.counter_id=$counterID";
$hdr = mysqli_query($conn, $sq);
$sale = mysqli_fetch_assoc($hdr);
if (!$sale) {
    echo "<div class='alert alert-danger'>Invoice not found.</div>";
    exit;
}

// Fetch items
$is = "SELECT si.quantity, si.price, si.total, p.name, cat.name AS category, sz.name AS size
         FROM sales_items si
         JOIN products p ON si.product_id=p.id
         LEFT JOIN categories cat ON p.category_id=cat.id
         LEFT JOIN sizes sz ON p.size_id=sz.id
         WHERE si.sale_id=$saleId";
$itQ = mysqli_query($conn, $is);
$items = mysqli_fetch_all($itQ, MYSQLI_ASSOC);

ob_start();
?>
<div class="invoice">
  <h2>Invoice #<?= $sale['id'] ?></h2>
  <p><strong>Date:</strong> <?= htmlspecialchars($sale['sale_date']) ?></p>
  <p><strong>Cashier:</strong> <?= htmlspecialchars($sale['full_name']) ?></p>
  <p><strong>Counter:</strong> <?= htmlspecialchars($sale['counter_name']) ?></p>
  <div class="d-flex justify-content-end mb-2">
    <label for="printMode" class="me-2">Print Mode:</label>
    <select id="printMode" class="form-select w-auto">
      <option value="normal">Normal</option>
      <option value="thermal">Thermal</option>
    </select>
  </div>
  <table class="table table-bordered">
    <thead><tr><th>Product</th><th>Category</th><th>Size</th><th>Qty</th><th>Price</th><th>Total</th></tr></thead>
    <tbody>
    <?php foreach ($items as $it): ?>
    <tr>
      <td><?= htmlspecialchars($it['name']) ?></td>
      <td><?= htmlspecialchars($it['category']) ?></td>
      <td><?= htmlspecialchars($it['size']) ?></td>
      <td><?= intval($it['quantity']) ?></td>
      <td>₹<?= number_format($it['price'],2) ?></td>
      <td>₹<?= number_format($it['total'],2) ?></td>
    </tr>
    <?php endforeach; ?>
    </tbody>
    <tfoot>
      <tr>
        <th colspan="5" class="text-end">Grand Total</th>
        <th>₹<?= number_format($sale['total_amount'],2) ?></th>
      </tr>
    </tfoot>
  </table>
  <?php if ($sale['payment_mode']==='upi' && getenv('UPI_ID')): ?>
    <?php
      $upiID = getenv('UPI_ID');
      $data = "upi://pay?pa={$upiID}&am={$sale['total_amount']}&cu=INR";
      $qrUrl = "https://api.qrserver.com/v1/create-qr-code/?size=120x120&data=" . urlencode($data);
    ?>
    <div class="text-center my-3">
      <img src="<?= $qrUrl ?>" alt="UPI QR Code">
      <p>Scan to pay via UPI</p>
    </div>
  <?php endif; ?>
  <button class="btn btn-primary" onclick="window.print()">Print Invoice</button>
</div>
<style>
.invoice { max-width:800px; margin:2rem auto; }
.invoice.thermal { width:240px; margin:auto; font-size:12px; }
.invoice.normal { max-width:800px; }
.invoice h2 { margin-bottom:1rem; }
@media print {
  body * { visibility: hidden; }
  .invoice, .invoice * { visibility: visible; }
  .invoice { position: absolute; top:0; left:0; width:100%; }
  .btn, #printMode, label[for="printMode"] { display:none !important; }
}
</style>
<script>
document.getElementById('printMode').addEventListener('change', function(e){
  const mode = e.target.value, inv = document.querySelector('.invoice');
  inv.classList.toggle('thermal', mode==='thermal');
  inv.classList.toggle('normal', mode==='normal');
});
</script>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
