<?php
header('Content-Type: application/json');
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'sales') {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}
$data = json_decode(file_get_contents('php://input'), true);
$type = $data['type'] ?? '';
$table_id = intval($data['table_id'] ?? 0);
$cart = $data['cart'] ?? [];
if (empty($cart)) {
    echo json_encode(['success' => false, 'message' => 'Cart is empty']);
    exit;
}
$user_id = $_SESSION['user_id'];
// Assigned counter
$res = mysqli_query($conn, "SELECT assigned_counter_id FROM users WHERE id=$user_id");
$counterID = intval(mysqli_fetch_assoc($res)['assigned_counter_id'] ?? 0);
// Compute total
$total = 0;
foreach ($cart as $item) {
    $total += ($item['price'] * $item['qty']);
}
// Capture payment mode
$paymentMode = mysqli_real_escape_string($conn, $data['payment_mode'] ?? 'cash');
// Begin transaction
mysqli_begin_transaction($conn);
try {
    // Insert sale
    $sql = "INSERT INTO sales (counter_id, total_amount, created_by, payment_mode) VALUES ($counterID, $total, $user_id, '$paymentMode')";
    if (!mysqli_query($conn, $sql)) throw new Exception(mysqli_error($conn));
    $saleId = mysqli_insert_id($conn);
    // Insert items and update stock
    foreach ($cart as $item) {
        $pid = intval($item['id']);
        $qty = intval($item['qty']);
        $price = floatval($item['price']);
        $itemTotal = $price * $qty;
        $ins = "INSERT INTO sales_items (sale_id, product_id, quantity, price, tax, total) VALUES ($saleId, $pid, $qty, $price, 0, $itemTotal)";
        if (!mysqli_query($conn, $ins)) throw new Exception(mysqli_error($conn));
        // Stock movement
        mysqli_query($conn, "INSERT INTO stock_movements (product_id, counter_id, movement_type, quantity) VALUES ($pid, $counterID, 'out', $qty)");
        // Update or insert counter stock
        $updSql = "UPDATE counter_stock SET quantity = quantity - $qty WHERE counter_id=$counterID AND product_id=$pid";
        if (!mysqli_query($conn, $updSql)) throw new Exception(mysqli_error($conn));
        // If no existing record, insert new (negative stock)
        if (mysqli_affected_rows($conn) === 0) {
            $initQty = 0 - $qty;
            $insStock = "INSERT INTO counter_stock (counter_id, product_id, quantity) VALUES ($counterID, $pid, $initQty)";
            if (!mysqli_query($conn, $insStock)) throw new Exception(mysqli_error($conn));
        }
    }
    mysqli_commit($conn);
    echo json_encode(['success' => true, 'sale_id' => $saleId]);
} catch (Exception $e) {
    mysqli_rollback($conn);
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
