<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'sales') redirect(BASE_URL . '/login.php');
$user_id = $_SESSION['user_id'];
$message = '';
$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $full_name = mysqli_real_escape_string($conn, trim($_POST['full_name'] ?? ''));
    $email = mysqli_real_escape_string($conn, trim($_POST['email'] ?? ''));
    if (empty($full_name) || empty($email)) {
        $error = 'Full name and email are required.';
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $error = 'Invalid email format.';
    } else {
        $sql = "UPDATE users SET full_name='$full_name', email='$email' WHERE id=$user_id";
        if (mysqli_query($conn, $sql)) {
            $message = 'Profile updated successfully.';
        } else {
            $error = 'Error: ' . mysqli_error($conn);
        }
    }
}
// Fetch updated user data
$res = mysqli_query($conn, "SELECT username, full_name, email FROM users WHERE id=$user_id");
$user = mysqli_fetch_assoc($res);
ob_start();
?>
<h1 class="h2 mb-4">Edit Profile</h1>
<?php if ($message): ?><div class="alert alert-success"><?= $message ?></div><?php endif; ?>
<?php if ($error): ?><div class="alert alert-danger"><?= $error ?></div><?php endif; ?>
<form method="post">
  <div class="mb-3">
    <label class="form-label">Username</label>
    <input type="text" class="form-control" value="<?= htmlspecialchars($user['username']) ?>" readonly>
  </div>
  <div class="mb-3">
    <label class="form-label">Full Name</label>
    <input type="text" name="full_name" class="form-control" value="<?= htmlspecialchars($user['full_name'] ?? '') ?>" required>
  </div>
  <div class="mb-3">
    <label class="form-label">Email</label>
    <input type="email" name="email" class="form-control" value="<?= htmlspecialchars($user['email'] ?? '') ?>" required>
  </div>
  <button type="submit" class="btn btn-primary">Save Changes</button>
</form>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
