<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'sales') redirect(BASE_URL . '/login.php');

// Assigned counter
$res = mysqli_query($conn, "SELECT assigned_counter_id FROM users WHERE id={$_SESSION['user_id']}");
$counterID = intval(mysqli_fetch_assoc($res)['assigned_counter_id'] ?? 0);

$message = '';
$err = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $product_id = intval($_POST['product_id'] ?? 0);
    $quantity = intval($_POST['quantity'] ?? 0);
    $remarks = mysqli_real_escape_string($conn, trim($_POST['remarks'] ?? ''));
    if ($product_id <= 0 || $quantity <=0) {
        $err = 'Please select a product and enter a valid quantity.';
    } else {
        $sql = "INSERT INTO stock_requests (counter_id, product_id, quantity, remarks, created_by) VALUES ($counterID, $product_id, $quantity, '$remarks', {$_SESSION['user_id']})";
        if (mysqli_query($conn, $sql)) {
            $message = 'Stock request submitted successfully.';
        } else {
            $err = 'Error: ' . mysqli_error($conn);
        }
    }
}
// Fetch products
$prodRes = mysqli_query($conn, 
    "SELECT p.id, p.name, c.name AS category, COALESCE(s.name,'') AS size
     FROM products p
     LEFT JOIN categories c ON p.category_id=c.id
     LEFT JOIN sizes s ON p.size_id=s.id
     ORDER BY p.name");
$products = mysqli_fetch_all($prodRes, MYSQLI_ASSOC);

ob_start();
?>
<div class="row mb-3 align-items-center">
  <div class="col-auto">
    <h1 class="h2 mb-0">New Stock Request</h1>
  </div>
  <div class="col-auto ms-auto">
    <a href="<?= BASE_URL ?>/panels/sales/current_stock.php" class="btn btn-secondary btn-sm">Back to Stock</a>
    <a href="<?= BASE_URL ?>/panels/sales/stock_history.php" class="btn btn-secondary btn-sm ms-2">History</a>
  </div>
</div>
<?php if ($message): ?>
  <div class="alert alert-success"><?= $message ?></div>
<?php endif; ?>
<?php if ($err): ?>
  <div class="alert alert-danger"><?= $err ?></div>
<?php endif; ?>
<form method="post">
  <div class="mb-3">
    <label class="form-label">Product</label>
    <select name="product_id" class="form-select" required>
      <option value="">Select product</option>
      <?php foreach ($products as $p): ?>
      <option value="<?= $p['id'] ?>" <?= (isset($_POST['product_id']) && $_POST['product_id']==$p['id'])?'selected':'' ?> >
        <?= htmlspecialchars("{$p['category']} - {$p['name']} ({$p['size']})") ?>
      </option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="mb-3">
    <label class="form-label">Quantity</label>
    <input type="number" name="quantity" class="form-control" min="1" value="<?= htmlspecialchars($_POST['quantity'] ?? '') ?>" required>
  </div>
  <div class="mb-3">
    <label class="form-label">Remarks</label>
    <textarea name="remarks" class="form-control" rows="3"><?= htmlspecialchars($_POST['remarks'] ?? '') ?></textarea>
  </div>
  <button type="submit" class="btn btn-primary">Submit Request</button>
</form>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
