<?php
header('Content-Type: application/json');
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'sales') {
    echo json_encode([]);
    exit;
}
$floorId = intval($_GET['floor'] ?? 0);
$tables = [];
if ($floorId) {
    // Fetch all tables on this floor
    $res = mysqli_query($conn, "SELECT t.id,t.table_number,t.seats,
        CASE WHEN EXISTS (SELECT 1 FROM table_orders o WHERE o.table_id=t.id AND o.status='open')
             THEN 'occupied' ELSE 'available' END AS status
        FROM tables t
        WHERE t.floor_id=$floorId");
    while ($row = mysqli_fetch_assoc($res)) {
        $tables[] = $row;
    }
}
echo json_encode($tables);
