<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'sales') redirect(BASE_URL . '/login.php');

// Fetch all tables with status
$res = mysqli_query($conn, "SELECT t.id, t.table_number, t.seats,
    CASE WHEN EXISTS(
        SELECT 1 FROM table_orders o WHERE o.table_id=t.id AND o.status='open'
    ) THEN 'occupied' ELSE 'available' END AS status
  FROM tables t ORDER BY t.table_number");
$tables = mysqli_fetch_all($res, MYSQLI_ASSOC);

ob_start();
?>
<h1 class="h2 mb-4 d-flex justify-content-between align-items-center">
  Table Management
  <a href="<?= BASE_URL ?>/panels/sales/pos.php?type=dinein" class="btn btn-primary btn-sm">Go to POS</a>
</h1>
<div class="row">
  <?php foreach ($tables as $table): ?>
    <?php $cls = $table['status']==='available' ? 'border-success' : 'border-danger'; ?>
    <div class="col-md-3 mb-4">
      <div class="card <?= $cls ?>">
        <div class="card-body text-center">
          <h5>Table <?= htmlspecialchars($table['table_number']) ?></h5>
          <p>Seats <?= intval($table['seats']) ?></p>
          <p>Status: <?= ucfirst($table['status']) ?></p>
          <a href="<?= BASE_URL ?>/panels/sales/pos.php?type=dinein&table_id=<?= $table['id'] ?>"
             class="btn btn-sm <?= $table['status']==='available' ? 'btn-success' : 'btn-danger' ?> mt-2">
            <?= $table['status']==='available' ? 'Select' : 'Open' ?>
          </a>
        </div>
      </div>
    </div>
  <?php endforeach; ?>
</div>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
