<?php
header('Content-Type: application/json');
require_once __DIR__.'/../../includes/db.php';
require_once __DIR__.'/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'sales') {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

// Handle POST: Save or update table order
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);
    $table_id = intval($data['table_id'] ?? 0);
    $cart = $data['cart'] ?? [];
    if (!$table_id) {
        echo json_encode(['success' => false, 'message' => 'No table selected']);
        exit;
    }
    // Check existing open order
    $res = mysqli_query($conn, "SELECT id FROM table_orders WHERE table_id=$table_id AND status='open' LIMIT 1");
    if ($row = mysqli_fetch_assoc($res)) {
        $order_id = intval($row['id']);
        mysqli_query($conn, "DELETE FROM table_order_items WHERE order_id=$order_id");
    } else {
        $user_id = $_SESSION['user_id'];
        mysqli_query($conn, "INSERT INTO table_orders (table_id, user_id, status) VALUES ($table_id, $user_id, 'open')");
        $order_id = mysqli_insert_id($conn);
    }
    // Insert items
    foreach ($cart as $item) {
        $pid = intval($item['id']);
        $qty = intval($item['qty']);
        $price = floatval($item['price']);
        mysqli_query($conn, "INSERT INTO table_order_items (order_id, product_id, quantity, price) VALUES ($order_id, $pid, $qty, $price)");
    }
    echo json_encode(['success' => true, 'order_id' => $order_id]);
    exit;
}

// Handle GET: Fetch existing open order
$table_id = intval($_GET['table'] ?? 0);
if ($table_id) {
    $res = mysqli_query($conn, "SELECT id FROM table_orders WHERE table_id=$table_id AND status='open' LIMIT 1");
    if ($row = mysqli_fetch_assoc($res)) {
        $order_id = intval($row['id']);
        $itemsRes = mysqli_query($conn, 
            "SELECT toi.product_id AS id, toi.quantity AS qty, toi.price, p.name \
             FROM table_order_items toi \
             JOIN products p ON p.id=toi.product_id \
             WHERE toi.order_id=$order_id");
        $items = [];
        while ($r = mysqli_fetch_assoc($itemsRes)) {
            $items[] = $r;
        }
        echo json_encode(['order_id' => $order_id, 'items' => $items]);
        exit;
    }
}
// No open order
echo json_encode(['order_id' => null, 'items' => []]);
exit;
