<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'warehouse') redirect(BASE_URL . '/login.php');

// Fetch metrics
$res = mysqli_query($conn, "SELECT SUM(quantity) AS total FROM counter_stock") or die(mysqli_error($conn));
$totalStock = mysqli_fetch_assoc($res)['total'] ?? 0;
$res = mysqli_query($conn, "SELECT COUNT(*) AS cnt FROM purchases WHERE DATE(purchase_date)=CURDATE()") or die(mysqli_error($conn));
$stockReceived = mysqli_fetch_assoc($res)['cnt'] ?? 0;
$res = mysqli_query($conn, "SELECT COUNT(*) AS cnt FROM stock_requests WHERE status='pending'") or die(mysqli_error($conn));
$pendingRequests = mysqli_fetch_assoc($res)['cnt'] ?? 0;
$res = mysqli_query($conn, "SELECT COUNT(*) AS cnt FROM dispatches WHERE DATE(dispatched_at)=CURDATE()") or die(mysqli_error($conn));
$dispatches = mysqli_fetch_assoc($res)['cnt'] ?? 0;
$res = mysqli_query($conn, "SELECT COUNT(*) AS cnt FROM counter_stock WHERE quantity < 10") or die(mysqli_error($conn));
$lowStock = mysqli_fetch_assoc($res)['cnt'] ?? 0;

ob_start();
?>
<div class="d-flex justify-content-between flex-wrap mb-4">
  <h1 class="h2">Warehouse Dashboard</h1>
  <small class="text-muted">Welcome, <?= htmlspecialchars($_SESSION['username'] ?? '') ?></small>
</div>
<div class="row g-3">
  <?php $widgets = [
    ['icon'=>'fa-boxes','value'=>$totalStock,'label'=>'Total Stock Available','color'=>'primary'],
    ['icon'=>'fa-download','value'=>$stockReceived,'label'=>'Stock Received Today','color'=>'success'],
    ['icon'=>'fa-hourglass-half','value'=>$pendingRequests,'label'=>'Pending Stock Requests','color'=>'warning'],
    ['icon'=>'fa-truck','value'=>$dispatches,'label'=>'Dispatches Today','color'=>'info'],
    ['icon'=>'fa-exclamation-triangle','value'=>$lowStock,'label'=>'Low Stock Alerts','color'=>'danger'],
  ]; ?>
  <?php foreach ($widgets as $w): ?>
  <div class="col-6 col-md-4 col-lg-3">
    <div class="card text-center">
      <div class="card-body">
        <div class="widget-icon-wrapper bg-<?= $w['color'] ?> mx-auto mb-3">
          <i class="fas <?= $w['icon'] ?> text-white"></i>
        </div>
        <h3><?= $w['value'] ?></h3>
        <p class="mb-0"><?= $w['label'] ?></p>
      </div>
    </div>
  </div>
  <?php endforeach; ?>
</div>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
