<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'warehouse') redirect(BASE_URL . '/login.php');

// Ensure dispatches extra columns
$cols = [
    'quantity_dispatched' => 'INT NOT NULL',
    'transport_note' => 'TEXT',
];
foreach ($cols as $col => $type) {
    $chk = mysqli_query($conn, "SHOW COLUMNS FROM `dispatches` LIKE '$col'");
    if (mysqli_num_rows($chk) === 0) {
        mysqli_query($conn, "ALTER TABLE `dispatches` ADD COLUMN `$col` $type");
    }
}

$message = '';
$errors = [];

// Handle dispatch form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['request_id'])) {
    $req_id = intval($_POST['request_id']);
    $quantity = intval($_POST['quantity']);
    $transport_note = trim($_POST['transport_note'] ?? '');
    $dispatch_date = $_POST['dispatch_date'] ?? '';
    
    // fetch request
    $res = mysqli_query($conn, "SELECT * FROM `stock_requests` WHERE id = $req_id AND status='approved'");
    if (mysqli_num_rows($res) > 0) {
        $sr = mysqli_fetch_assoc($res);
        $pid = $sr['product_id'];
        $cid = $sr['counter_id'];
        // update warehouse stock
        $r1 = mysqli_query($conn, "SELECT quantity FROM warehouse_stock WHERE product_id = $pid");
        if (mysqli_num_rows($r1) > 0) {
            $ws = mysqli_fetch_assoc($r1)['quantity'];
            $new_ws = $ws - $quantity;
            mysqli_query($conn, "UPDATE warehouse_stock SET quantity = $new_ws, last_updated = NOW() WHERE product_id = $pid");
        }
        // update counter stock
        $r2 = mysqli_query($conn, "SELECT quantity FROM counter_stock WHERE counter_id = $cid AND product_id = $pid");
        if (mysqli_num_rows($r2) > 0) {
            $cs = mysqli_fetch_assoc($r2)['quantity'];
            $new_cs = $cs + $quantity;
            mysqli_query($conn, "UPDATE counter_stock SET quantity = $new_cs, last_updated = NOW() WHERE counter_id = $cid AND product_id = $pid");
        } else {
            mysqli_query($conn, "INSERT INTO counter_stock (counter_id, product_id, quantity) VALUES ($cid, $pid, $quantity)");
        }
        // record dispatch
        $dt = mysqli_real_escape_string($conn, $dispatch_date . ' ' . date('H:i:s'));
        $note = mysqli_real_escape_string($conn, $transport_note);
        mysqli_query($conn, "INSERT INTO dispatches (stock_request_id, dispatched_by, dispatched_at, quantity_dispatched, transport_note) VALUES ($req_id, {$_SESSION['user_id']}, '$dt', $quantity, '$note')");
        // update request
        mysqli_query($conn, "UPDATE stock_requests SET status='dispatched' WHERE id = $req_id");
        // log movement out
        $reason = mysqli_real_escape_string($conn, "Dispatch for request $req_id: $transport_note");
        mysqli_query($conn, "INSERT INTO stock_movements (product_id, type, quantity, user_id, reason, created_at) VALUES ($pid, 'out', $quantity, {$_SESSION['user_id']}, '$reason', '$dt')");
        $message = 'Request #'.$req_id.' dispatched successfully.';
    } else {
        $errors[] = 'Invalid or already dispatched request.';
    }
}

// fetch approved requests
$sql = "SELECT sr.id,sr.quantity,sr.remarks,sr.created_at, c.name AS counter,p.name AS product
    FROM stock_requests sr
    LEFT JOIN counters c ON sr.counter_id=c.id
    LEFT JOIN products p ON sr.product_id=p.id
    WHERE sr.status='approved' ORDER BY sr.created_at DESC";
$res = mysqli_query($conn, $sql) or die(mysqli_error($conn));
$rows = mysqli_fetch_all($res, MYSQLI_ASSOC);

ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-4">
  <h1 class="h2">Dispatch Stock</h1>
</div>
<?php if ($message): ?>
  <div class="alert alert-success"><?= htmlspecialchars($message) ?></div>
<?php endif; ?>
<?php if (!empty($errors)): foreach ($errors as $e): ?>
  <div class="alert alert-danger"><?= htmlspecialchars($e) ?></div>
<?php endforeach; endif; ?>

<?php if (isset($_GET['id'])):
  $did = intval($_GET['id']);
  // fetch single request
  $r = array_filter($rows, fn($x)=>$x['id']===$did)[0] ?? null;
  if ($r): ?>
<div class="card mb-4">
  <div class="card-body">
    <h5>Dispatch Request #<?= $r['id'] ?></h5>
    <p>Counter: <?= htmlspecialchars($r['counter']) ?> | Product: <?= htmlspecialchars($r['product']) ?> | Qty: <?= $r['quantity'] ?></p>
    <form method="POST">
      <input type="hidden" name="request_id" value="<?= $r['id'] ?>">
      <div class="mb-3">
        <label class="form-label">Dispatch Quantity</label>
        <input type="number" name="quantity" class="form-control" min="1" max="<?= $r['quantity'] ?>" value="<?= $r['quantity'] ?>" required>
      </div>
      <div class="mb-3">
        <label class="form-label">Transport Note</label>
        <input type="text" name="transport_note" class="form-control">
      </div>
      <div class="mb-3">
        <label class="form-label">Dispatch Date</label>
        <input type="date" name="dispatch_date" class="form-control" value="<?= date('Y-m-d') ?>" required>
      </div>
      <button class="btn btn-primary">Dispatch</button>
      <a href="<?= BASE_URL.'/panels/warehouse/dispatch_stock.php' ?>" class="btn btn-link">Back</a>
    </form>
  </div>
</div>
<?php endif; endif; ?>

<?php if (!isset($_GET['id'])): ?>
<table class="table table-striped table-hover">
  <thead>
    <tr><th>ID</th><th>Date</th><th>Counter</th><th>Product</th><th>Qty</th><th>Remarks</th><th>Action</th></tr>
  </thead>
  <tbody>
  <?php foreach ($rows as $r): ?>
    <tr>
      <td><?= $r['id'] ?></td>
      <td><?= $r['created_at'] ?></td>
      <td><?= htmlspecialchars($r['counter']) ?></td>
      <td><?= htmlspecialchars($r['product']) ?></td>
      <td><?= $r['quantity'] ?></td>
      <td><?= htmlspecialchars($r['remarks']) ?></td>
      <td><a href="?id=<?= $r['id'] ?>" class="btn btn-sm btn-primary">Dispatch</a></td>
    </tr>
  <?php endforeach; ?>
  </tbody>
</table>
<?php endif; ?>

<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
