<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'warehouse') redirect(BASE_URL . '/login.php');

// Ensure notifications table exists
$create = "CREATE TABLE IF NOT EXISTS `warehouse_notifications` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `emails` TEXT NOT NULL,
  `low_stock_alert` TINYINT(1) NOT NULL DEFAULT 0,
  `request_approval_alert` TINYINT(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
mysqli_query($conn, $create) or die(mysqli_error($conn));

// Fetch current settings
$res = mysqli_query($conn, "SELECT * FROM warehouse_notifications LIMIT 1");
$settings = mysqli_fetch_assoc($res) ?: ['id'=>0,'emails'=>'','low_stock_alert'=>0,'request_approval_alert'=>0];

$message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $emails = trim($_POST['emails'] ?? '');
    $low = isset($_POST['low_stock_alert']) ? 1 : 0;
    $req = isset($_POST['request_approval_alert']) ? 1 : 0;
    if ($emails === '') {
        $message = 'Provide at least one notification email.';
    } else {
        $emails_sql = mysqli_real_escape_string($conn, $emails);
        if ($settings['id']) {
            mysqli_query($conn, "UPDATE warehouse_notifications SET emails='$emails_sql', low_stock_alert=$low, request_approval_alert=$req WHERE id={$settings['id']}") or die(mysqli_error($conn));
        } else {
            mysqli_query($conn, "INSERT INTO warehouse_notifications (emails, low_stock_alert, request_approval_alert) VALUES ('$emails_sql',$low,$req)") or die(mysqli_error($conn));
        }
        $message = 'Notification settings saved.';
        // refresh settings
        $res = mysqli_query($conn, "SELECT * FROM warehouse_notifications LIMIT 1");
        $settings = mysqli_fetch_assoc($res);
    }
}

ob_start();
?>
<div class="mb-4"><h1 class="h2">Notification Settings</h1></div>
<?php if ($message): ?><div class="alert alert-info"><?= htmlspecialchars($message) ?></div><?php endif; ?>
<div class="card mb-4"><div class="card-body">
  <form method="POST">
    <div class="mb-3">
      <label class="form-label">Notification Emails (comma-separated)</label>
      <textarea name="emails" class="form-control" rows="2" required><?= htmlspecialchars($settings['emails']) ?></textarea>
    </div>
    <div class="form-check form-switch mb-3">
      <input class="form-check-input" type="checkbox" id="lowSwitch" name="low_stock_alert" <?= $settings['low_stock_alert']?'checked':'' ?>>
      <label class="form-check-label" for="lowSwitch">Low Stock Alerts</label>
    </div>
    <div class="form-check form-switch mb-3">
      <input class="form-check-input" type="checkbox" id="reqSwitch" name="request_approval_alert" <?= $settings['request_approval_alert']?'checked':'' ?>>
      <label class="form-check-label" for="reqSwitch">Request Approval Alerts</label>
    </div>
    <button type="submit" class="btn btn-primary">Save Settings</button>
  </form>
</div></div>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
