<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'warehouse') redirect(BASE_URL . '/login.php');

$message = '';
$errors = [];
$id = intval($_GET['id'] ?? 0);

// Fetch suppliers and products
$suppliers = mysqli_query($conn, "SELECT id, name FROM suppliers ORDER BY name") or die(mysqli_error($conn));
$products = mysqli_query($conn, "SELECT id, name FROM products ORDER BY name") or die(mysqli_error($conn));

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $supplier_id = intval($_POST['supplier_id'] ?? 0);
    $purchase_date = $_POST['purchase_date'] ?? '';
    $quantities = $_POST['quantity'] ?? [];
    $unit_costs = $_POST['unit_cost'] ?? [];
    $taxes = $_POST['tax'] ?? [];
    $product_ids = $_POST['product_id'] ?? [];

    if ($supplier_id <= 0) $errors[] = 'Select a supplier.';
    if ($purchase_date === '') $errors[] = 'Purchase date is required.';
    if (empty($product_ids)) $errors[] = 'Add at least one item.';

    $items = [];
    $total_amount = 0;
    foreach ($product_ids as $i => $pid) {
        $pid = intval($pid);
        $qty = intval($quantities[$i] ?? 0);
        $cost = floatval($unit_costs[$i] ?? 0);
        $tax = floatval($taxes[$i] ?? 0);
        if ($pid <= 0 || $qty <= 0 || $cost <= 0) continue;
        $line_total = $qty * $cost + ($qty * $cost * ($tax/100));
        $total_amount += $line_total;
        $items[] = [ 'product_id'=>$pid, 'quantity'=>$qty, 'unit_cost'=>$cost, 'tax'=>$tax, 'line_total'=>$line_total ];
    }
    if (empty($items)) $errors[] = 'Valid items required.';

    if (empty($errors)) {
        if ($id) {
            mysqli_query($conn, "UPDATE purchases SET supplier_id=$supplier_id, purchase_date='".mysqli_real_escape_string($conn,$purchase_date)."', total_amount=$total_amount WHERE id=$id") or die(mysqli_error($conn));
            mysqli_query($conn, "DELETE FROM purchase_items WHERE purchase_id=$id") or die(mysqli_error($conn));
        } else {
            mysqli_query($conn, "INSERT INTO purchases (supplier_id,purchase_date,total_amount) VALUES ($supplier_id,'".mysqli_real_escape_string($conn,$purchase_date)."',$total_amount)") or die(mysqli_error($conn));
            $id = mysqli_insert_id($conn);
        }
        foreach ($items as $it) {
            mysqli_query($conn, "INSERT INTO purchase_items (purchase_id,product_id,quantity,unit_cost,tax,line_total) VALUES ($id,{$it['product_id']},{$it['quantity']},{$it['unit_cost']},{$it['tax']},{$it['line_total']})") or die(mysqli_error($conn));
        }
        redirect(BASE_URL . '/panels/warehouse/purchase_list.php');
    }
}

// On GET, fetch existing items
$existing = [];
if ($id) {
    $pq = mysqli_query($conn, "SELECT * FROM purchase_items WHERE purchase_id=$id") or die(mysqli_error($conn));
    while ($r = mysqli_fetch_assoc($pq)) $existing[] = $r;
    $pinfo = mysqli_query($conn, "SELECT supplier_id, DATE(purchase_date) AS pd FROM purchases WHERE id=$id") or die(mysqli_error($conn));
    $pi = mysqli_fetch_assoc($pinfo);
    $sel_supplier = $pi['supplier_id'];
    $sel_date = $pi['pd'];
} else {
    $sel_supplier = 0;
    $sel_date = date('Y-m-d');
}

ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-4">
  <h1 class="h2"><?= $id ? 'Edit' : 'New' ?> Purchase</h1>
</div>
<?php if (!empty($errors)): foreach ($errors as $e): ?>
  <div class="alert alert-danger"><?= htmlspecialchars($e) ?></div>
<?php endforeach; endif; ?>
<div class="card mb-4">
  <div class="card-body">
    <form method="POST" id="purchaseForm">
      <div class="row mb-3">
        <div class="col-md-6">
          <label class="form-label">Supplier</label>
          <select name="supplier_id" class="form-select" required>
            <option value="">Select supplier</option>
<?php while ($s = mysqli_fetch_assoc($suppliers)): ?>
            <option value="<?= $s['id'] ?>" <?= $s['id']==$sel_supplier?'selected':'' ?>><?= htmlspecialchars($s['name']) ?></option>
<?php endwhile; ?>
          </select>
        </div>
        <div class="col-md-6">
          <label class="form-label">Purchase Date</label>
          <input type="date" name="purchase_date" class="form-control" value="<?= $sel_date ?>" required>
        </div>
      </div>
      <table class="table table-bordered" id="itemsTable">
        <thead><tr><th>Product</th><th>Qty</th><th>Unit Cost</th><th>Tax %</th><th>Action</th></tr></thead>
        <tbody>
<?php if ($existing): foreach ($existing as $it): ?>
        <tr>
          <td><select name="product_id[]" class="form-select" required>
              <option value="">Select</option>
<?php mysqli_data_seek($products,0); while($p=mysqli_fetch_assoc($products)): ?>
              <option value="<?= $p['id'] ?>" <?= $p['id']==$it['product_id']?'selected':'' ?>><?= htmlspecialchars($p['name']) ?></option>
<?php endwhile;?>
          </select></td>
          <td><input type="number" name="quantity[]" class="form-control" value="<?= $it['quantity'] ?>" required></td>
          <td><input type="number" step="0.01" name="unit_cost[]" class="form-control" value="<?= $it['unit_cost'] ?>" required></td>
          <td><input type="number" step="0.01" name="tax[]" class="form-control" value="<?= $it['tax'] ?>"></td>
          <td><button type="button" class="btn btn-sm btn-danger removeRow">X</button></td>
        </tr>
<?php endforeach; else: ?>
        <tr>
          <td><select name="product_id[]" class="form-select" required><option value="">Select</option><?php mysqli_data_seek($products,0); while($p=mysqli_fetch_assoc($products)): ?><option value="<?= $p['id'] ?>"><?= htmlspecialchars($p['name']) ?></option><?php endwhile;?></select></td>
          <td><input type="number" name="quantity[]" class="form-control" required></td>
          <td><input type="number" step="0.01" name="unit_cost[]" class="form-control" required></td>
          <td><input type="number" step="0.01" name="tax[]" class="form-control"></td>
          <td><button type="button" class="btn btn-sm btn-danger removeRow">X</button></td>
        </tr>
<?php endif; ?>
        </tbody>
      </table>
      <button type="button" class="btn btn-secondary mb-3" id="addItem">Add Item</button>
      <button type="submit" class="btn btn-primary">Save Purchase</button>
    </form>
  </div>
</div>
<script>
document.getElementById('addItem').addEventListener('click',()=>{
  const table = document.getElementById('itemsTable').querySelector('tbody');
  const row = table.rows[0].cloneNode(true);
  row.querySelectorAll('input').forEach(i=>i.value='');
  row.querySelector('select').selectedIndex=0;
  table.appendChild(row);
});
document.querySelector('#itemsTable').addEventListener('click',e=>{
  if(e.target.classList.contains('removeRow')){
    const rows = e.target.closest('tbody').rows;
    if(rows.length>1) e.target.closest('tr').remove();
  }
});
</script>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
