<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'warehouse') redirect(BASE_URL . '/login.php');

// Ensure purchase_items table exists
$createPi = "CREATE TABLE IF NOT EXISTS `purchase_items` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `purchase_id` INT UNSIGNED NOT NULL,
  `product_id` INT UNSIGNED NOT NULL,
  `quantity` INT NOT NULL DEFAULT 0,
  `unit_cost` DECIMAL(10,2) NOT NULL,
  `tax` DECIMAL(5,2) NOT NULL DEFAULT 0,
  `line_total` DECIMAL(12,2) NOT NULL,
  `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_pi_purchase` (`purchase_id`),
  KEY `fk_pi_product` (`product_id`),
  CONSTRAINT `fk_pi_purchase` FOREIGN KEY (`purchase_id`) REFERENCES `purchases`(`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_pi_product` FOREIGN KEY (`product_id`) REFERENCES `products`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
mysqli_query($conn, $createPi) or die(mysqli_error($conn));

// Fetch purchases
$sql = "SELECT p.id, p.purchase_date, s.name AS supplier_name, p.total_amount
        FROM purchases p
        LEFT JOIN suppliers s ON p.supplier_id = s.id
        ORDER BY p.purchase_date DESC";
$res = mysqli_query($conn, $sql) or die(mysqli_error($conn));
$purchases = mysqli_fetch_all($res, MYSQLI_ASSOC);

ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-4">
  <h1 class="h2">Purchase Orders</h1>
  <a href="<?= BASE_URL ?>/panels/warehouse/purchase_form.php" class="btn btn-primary">Add New Purchase</a>
</div>
<table class="table table-striped table-hover">
  <thead>
    <tr>
      <th>ID</th>
      <th>Date</th>
      <th>Supplier</th>
      <th>Total Amount</th>
      <th>Action</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($purchases as $row): ?>
    <tr>
      <td><?= $row['id'] ?></td>
      <td><?= $row['purchase_date'] ?></td>
      <td><?= htmlspecialchars($row['supplier_name']) ?></td>
      <td><?= number_format($row['total_amount'],2) ?></td>
      <td><a href="<?= BASE_URL ?>/panels/warehouse/purchase_form.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-warning">Edit</a></td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
