<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'warehouse') redirect(BASE_URL . '/login.php');

$message = '';
$errors = [];
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $product_id = intval($_POST['product_id'] ?? 0);
    $quantity = intval($_POST['quantity'] ?? 0);
    $adjustment_type = $_POST['adjustment_type'] ?? '';
    $reason = trim($_POST['reason'] ?? '');

    if ($product_id <= 0) $errors[] = 'Select a product.';
    if ($quantity <= 0) $errors[] = 'Quantity must be at least 1.';
    if (!in_array($adjustment_type, ['add', 'remove'])) $errors[] = 'Invalid adjustment type.';
    if ($reason === '') $errors[] = 'Reason is required.';

    if (empty($errors)) {
        $res = mysqli_query($conn, "SELECT quantity FROM warehouse_stock WHERE product_id = $product_id");
        $current_qty = 0;
        if (mysqli_num_rows($res) > 0) {
            $current_qty = mysqli_fetch_assoc($res)['quantity'];
        }
        if ($adjustment_type === 'add') {
            $new_qty = $current_qty + $quantity;
        } else {
            if ($quantity > $current_qty) {
                $errors[] = 'Cannot remove more than available stock.';
            } else {
                $new_qty = $current_qty - $quantity;
            }
        }

        if (empty($errors)) {
            if (mysqli_num_rows($res) > 0) {
                mysqli_query($conn, "UPDATE warehouse_stock SET quantity = $new_qty, last_updated = NOW() WHERE product_id = $product_id");
            } else {
                mysqli_query($conn, "INSERT INTO warehouse_stock (product_id, quantity) VALUES ($product_id, $new_qty)");
            }
            $reason_sql = mysqli_real_escape_string($conn, ($adjustment_type === 'add' ? 'Add: ' : 'Remove: ') . $reason);
            mysqli_query($conn, "INSERT INTO stock_movements (product_id, type, quantity, user_id, reason, created_at) VALUES ($product_id, 'adjust', $quantity, {$_SESSION['user_id']}, '$reason_sql', NOW())");
            $message = 'Stock adjusted successfully.';
        }
    }
}
// Fetch products
$products = [];
$sql = "SELECT p.id, p.name AS product_name, COALESCE(b.name,'') AS brand_name, COALESCE(s.name,'') AS size_name
        FROM products p
        LEFT JOIN brands b ON p.brand_id = b.id
        LEFT JOIN sizes s ON p.size_id = s.id
        ORDER BY p.name";
$res = mysqli_query($conn, $sql) or die(mysqli_error($conn));
while ($r = mysqli_fetch_assoc($res)) $products[] = $r;

ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-4">
  <h1 class="h2">Stock Adjustment</h1>
</div>
<?php if ($message): ?>
<div class="alert alert-success"><?= htmlspecialchars($message) ?></div>
<?php endif; ?>
<?php if (!empty($errors)): foreach ($errors as $err): ?>
<div class="alert alert-danger"><?= htmlspecialchars($err) ?></div>
<?php endforeach; endif; ?>

<div class="card mb-4">
  <div class="card-body">
    <form method="POST">
      <div class="mb-3">
        <label class="form-label">Product</label>
        <select name="product_id" class="form-select">
<?php foreach ($products as $p): ?>
          <option value="<?= $p['id'] ?>"><?= htmlspecialchars($p['product_name'] . ' (' . $p['brand_name'] . ', ' . $p['size_name'] . ')') ?></option>
<?php endforeach; ?>
        </select>
      </div>
      <div class="mb-3">
        <label class="form-label">Adjustment Type</label>
        <select name="adjustment_type" class="form-select">
          <option value="add">Add</option>
          <option value="remove">Remove</option>
        </select>
      </div>
      <div class="mb-3">
        <label class="form-label">Quantity</label>
        <input type="number" name="quantity" class="form-control" min="1" required>
      </div>
      <div class="mb-3">
        <label class="form-label">Reason</label>
        <input type="text" name="reason" class="form-control" required>
      </div>
      <button type="submit" class="btn btn-primary">Submit</button>
    </form>
  </div>
</div>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
