<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'warehouse') redirect(BASE_URL . '/login.php');

// Filters
$brands = mysqli_query($conn, "SELECT id, name FROM brands ORDER BY name");
$categories = mysqli_query($conn, "SELECT id, name FROM categories ORDER BY name");
$from = $_GET['from'] ?? '';
$to = $_GET['to'] ?? '';
$brand_id = intval($_GET['brand_id'] ?? 0);
$cat_id = intval($_GET['cat_id'] ?? 0);

$where = [];
if ($brand_id) $where[] = "p.brand_id = $brand_id";
if ($cat_id) $where[] = "p.category_id = $cat_id";
if ($from) $where[] = "ws.last_updated >= '".mysqli_real_escape_string($conn,$from." 00:00:00")."'";
if ($to) $where[] = "ws.last_updated <= '".mysqli_real_escape_string($conn,$to." 23:59:59")."'";
$w = $where ? 'WHERE '.implode(' AND ',$where) : '';

$sql = "SELECT p.name AS product, b.name AS brand, c.name AS category, s.name AS size,
            ws.quantity, ws.last_updated
        FROM warehouse_stock ws
        JOIN products p ON ws.product_id = p.id
        LEFT JOIN brands b ON p.brand_id = b.id
        LEFT JOIN categories c ON p.category_id = c.id
        LEFT JOIN sizes s ON p.size_id = s.id
        $w ORDER BY p.name";
$res = mysqli_query($conn,$sql) or die(mysqli_error($conn));
$data = mysqli_fetch_all($res,MYSQLI_ASSOC);

// Export CSV
if (isset($_GET['export']) && $_GET['export'] === 'csv') {
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="stock_report.csv"');
    $out = fopen('php://output','w');
    fputcsv($out, array_keys($data[0] ?? []));
    foreach ($data as $row) fputcsv($out,$row);
    exit;
}

ob_start();
?>
<h1 class="h2 mb-4">Stock Report</h1>
<form class="row g-3 mb-4" method="GET">
  <div class="col-md-3"><input type="date" name="from" value="<?= htmlspecialchars($from) ?>" class="form-control" placeholder="From"></div>
  <div class="col-md-3"><input type="date" name="to" value="<?= htmlspecialchars($to) ?>" class="form-control" placeholder="To"></div>
  <div class="col-md-3">
    <select name="brand_id" class="form-select">
      <option value="">All Brands</option>
      <?php while($b = mysqli_fetch_assoc($brands)): ?>
      <option value="<?= $b['id'] ?>" <?= $b['id']==$brand_id?'selected':'' ?>><?= htmlspecialchars($b['name']) ?></option>
      <?php endwhile; ?>
    </select>
  </div>
  <div class="col-md-3">
    <select name="cat_id" class="form-select">
      <option value="">All Categories</option>
      <?php while($c = mysqli_fetch_assoc($categories)): ?>
      <option value="<?= $c['id'] ?>" <?= $c['id']==$cat_id?'selected':'' ?>><?= htmlspecialchars($c['name']) ?></option>
      <?php endwhile; ?>
    </select>
  </div>
  <div class="col-12">
    <button type="submit" class="btn btn-primary">Filter</button>
    <a href="?<?= htmlspecialchars($_SERVER['QUERY_STRING']) ?>&export=csv" class="btn btn-secondary">Export CSV</a>
  </div>
</form>
<table class="table table-striped table-hover">
  <thead><tr><th>Product</th><th>Brand</th><th>Category</th><th>Size</th><th>Qty</th><th>Last Updated</th></tr></thead>
  <tbody>
    <?php foreach ($data as $r): ?>
    <tr>
      <td><?= htmlspecialchars($r['product']) ?></td>
      <td><?= htmlspecialchars($r['brand']) ?></td>
      <td><?= htmlspecialchars($r['category']) ?></td>
      <td><?= htmlspecialchars($r['size']) ?></td>
      <td><?= $r['quantity'] ?></td>
      <td><?= $r['last_updated'] ?></td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
