<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'warehouse') redirect(BASE_URL . '/login.php');

// Ensure tables
$createWs = "CREATE TABLE IF NOT EXISTS `warehouse_stock` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `product_id` INT UNSIGNED NOT NULL,
  `quantity` INT NOT NULL DEFAULT 0,
  `last_updated` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq_ws_product` (`product_id`),
  KEY `fk_ws_product` (`product_id`),
  CONSTRAINT `fk_ws_product` FOREIGN KEY (`product_id`) REFERENCES `products`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
mysqli_query($conn, $createWs) or die(mysqli_error($conn));
$createSm = "CREATE TABLE IF NOT EXISTS `stock_movements` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `product_id` INT UNSIGNED NOT NULL,
  `type` ENUM('in','out','adjust') NOT NULL,
  `quantity` INT NOT NULL,
  `user_id` INT UNSIGNED,
  `reason` TEXT,
  `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_sm_product` (`product_id`),
  KEY `fk_sm_user` (`user_id`),
  CONSTRAINT `fk_sm_product` FOREIGN KEY (`product_id`) REFERENCES `products`(`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_sm_user` FOREIGN KEY (`user_id`) REFERENCES `users`(`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
mysqli_query($conn, $createSm) or die(mysqli_error($conn));

// Fetch current stock
$sql = "SELECT ws.quantity, ws.last_updated, p.name AS product_name, b.name AS brand_name, s.name AS size_name
  FROM warehouse_stock ws
  JOIN products p ON ws.product_id = p.id
  LEFT JOIN brands b ON p.brand_id = b.id
  LEFT JOIN sizes s ON p.size_id = s.id
  ORDER BY p.name";
$res = mysqli_query($conn, $sql) or die(mysqli_error($conn));
$rows = mysqli_fetch_all($res, MYSQLI_ASSOC);

ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-4">
  <h1 class="h2">Warehouse Stock</h1>
</div>
<table class="table table-striped table-hover">
  <thead>
    <tr>
      <th>Product</th>
      <th>Brand</th>
      <th>Size</th>
      <th>Quantity</th>
      <th>Last Updated</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($rows as $r): ?>
    <tr>
      <td><?= htmlspecialchars($r['product_name']) ?></td>
      <td><?= htmlspecialchars($r['brand_name']) ?></td>
      <td><?= htmlspecialchars($r['size_name']) ?></td>
      <td><?= $r['quantity'] ?></td>
      <td><?= $r['last_updated'] ?></td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
