<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'warehouse') redirect(BASE_URL . '/login.php');

// Ensure warehouse_info table exists
$create = "CREATE TABLE IF NOT EXISTS `warehouse_info` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(150) NOT NULL,
  `contact_person` VARCHAR(100) NOT NULL,
  `address` TEXT NOT NULL,
  `phone` VARCHAR(50),
  `email` VARCHAR(100),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
mysqli_query($conn, $create) or die(mysqli_error($conn));

// Handle form submission
$message = '';
$errors = [];
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $contact = trim($_POST['contact_person'] ?? '');
    $address = trim($_POST['address'] ?? '');
    $phone = trim($_POST['phone'] ?? '');
    $email = trim($_POST['email'] ?? '');
    if ($name === '') $errors[] = 'Warehouse name is required.';
    if ($contact === '') $errors[] = 'Contact person is required.';
    if ($address === '') $errors[] = 'Address is required.';
    if ($email !== '' && !filter_var($email, FILTER_VALIDATE_EMAIL)) $errors[] = 'Invalid email address.';

    if (empty($errors)) {
        $row = mysqli_fetch_assoc(mysqli_query($conn, "SELECT id FROM warehouse_info LIMIT 1"));
        if ($row) {
            $id = $row['id'];
            $sql = sprintf(
                "UPDATE warehouse_info SET name='%s', contact_person='%s', address='%s', phone='%s', email='%s' WHERE id=%d",
                mysqli_real_escape_string($conn, $name),
                mysqli_real_escape_string($conn, $contact),
                mysqli_real_escape_string($conn, $address),
                mysqli_real_escape_string($conn, $phone),
                mysqli_real_escape_string($conn, $email),
                $id
            );
        } else {
            $sql = sprintf(
                "INSERT INTO warehouse_info (name,contact_person,address,phone,email) VALUES ('%s','%s','%s','%s','%s')",
                mysqli_real_escape_string($conn, $name),
                mysqli_real_escape_string($conn, $contact),
                mysqli_real_escape_string($conn, $address),
                mysqli_real_escape_string($conn, $phone),
                mysqli_real_escape_string($conn, $email)
            );
        }
        mysqli_query($conn, $sql) or die(mysqli_error($conn));
        $message = 'Warehouse details saved.';
    }
}
// Fetch existing details
$info = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM warehouse_info LIMIT 1")) ?: [];

ob_start();
?>
<div class="mb-4">
  <h1 class="h2">Warehouse Details</h1>
</div>
<?php if ($message): ?><div class="alert alert-success"><?= htmlspecialchars($message) ?></div><?php endif; ?>
<?php if ($errors): foreach ($errors as $e): ?><div class="alert alert-danger"><?= htmlspecialchars($e) ?></div><?php endforeach; endif; ?>
<div class="card">
  <div class="card-body">
    <form method="POST">
      <div class="mb-3">
        <label class="form-label">Warehouse Name</label>
        <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($info['name'] ?? '') ?>" required>
      </div>
      <div class="mb-3">
        <label class="form-label">Contact Person</label>
        <input type="text" name="contact_person" class="form-control" value="<?= htmlspecialchars($info['contact_person'] ?? '') ?>" required>
      </div>
      <div class="mb-3">
        <label class="form-label">Address</label>
        <textarea name="address" class="form-control" rows="3" required><?= htmlspecialchars($info['address'] ?? '') ?></textarea>
      </div>
      <div class="mb-3">
        <label class="form-label">Phone</label>
        <input type="text" name="phone" class="form-control" value="<?= htmlspecialchars($info['phone'] ?? '') ?>">
      </div>
      <div class="mb-3">
        <label class="form-label">Email</label>
        <input type="email" name="email" class="form-control" value="<?= htmlspecialchars($info['email'] ?? '') ?>">
      </div>
      <button type="submit" class="btn btn-primary">Save</button>
    </form>
  </div>
</div>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
