<?php
/**
 * seed_users.php
 *
 * Deletes existing users and inserts default seed accounts with known passwords.
 * Usage: php seed_users.php
 */
require __DIR__ . '/includes/config.php';
require __DIR__ . '/includes/db.php';

// Delete existing users (audit_logs.user_id will be set to NULL via FK)
mysqli_query($conn, "DELETE FROM users;") or die("Error deleting users: " . mysqli_error($conn));
// Reset AUTO_INCREMENT
mysqli_query($conn, "ALTER TABLE users AUTO_INCREMENT = 1;") or die("Error resetting AUTO_INCREMENT: " . mysqli_error($conn));

// Prepare seed data
$accounts = [
    ['admin',     'admin123',     'admin',     'Administrator',     'admin@yourdomain.com',     null],
    ['manager1',  'manager123',   'manager',   'Manager One',      'manager1@yourdomain.com', 1],
    ['sales1',    'sales123',     'sales',     'Sales Rep',         'sales1@yourdomain.com',   1],
    ['warehouse1','warehouse123', 'warehouse','Warehouse Staff',   'warehouse@yourdomain.com', null],
];

$values = [];
foreach ($accounts as $acct) {
    list($user, $pass, $role, $name, $email, $cid) = $acct;
    $hash = password_hash($pass, PASSWORD_DEFAULT);
    $cidVal = $cid === null ? 'NULL' : (int)$cid;
    $values[] = sprintf("('%s','%s','%s','%s','%s',%s)",
        addslashes($user),
        addslashes($hash),
        addslashes($role),
        addslashes($name),
        addslashes($email),
        $cidVal
    );
}
$sql = "INSERT INTO users (username,password,role,full_name,email,assigned_counter_id) VALUES \n" . implode(",\n", $values) . ";";

// Insert seed accounts
mysqli_query($conn, $sql) or die("Error inserting seed users: " . mysqli_error($conn));

echo "Seeded default users successfully.\n";
